/*
solvelib::insertCoordinate(S, i, value)

inserts value as an i-th coordinate into every vector in the set S

i.e., computes {[x1, .., x_{i-1}, value, x_i, ..., x_n]; [x1, ..., x_n] in S}

*/

solvelib::insertCoordinate:= 
proc(S: Type::Set, i: DOM_INT, value)
  local insert: DOM_PROC, l, j;
begin
  
  // local method insert(v)
  // inserts value at the i-th position into the vector v
  // v must be of type DOM_LIST or matrix 
  insert:= 
  proc(v)
    local k;
  begin
    matrix([v[k] $k = 1..i-1, value, v[k] $k=i..nops(v)])
  end_proc;  
  
  case type(S)
  of DOM_SET do 
    return(map(S, insert))
  of piecewise do
    S:= piecewise::extmap(S, solvelib::insertCoordinate, i, value);
    if contains(piecewise::expressions(S), FAIL) > 0 then
      return(FAIL)
    else
      return(S)
    end_if  
  of "_union" do
  of "_intersect" do
  of "_minus" do
    l:= map([op(S)], solvelib::insertCoordinate, i, value);
    if contains(l, FAIL) > 0 then
      return(FAIL)
    else 
      return(op(S, 0)(op(l)))
    end_if
  of solvelib::VectorImageSet do  
    return(map(S, insert))
  of solvelib::cartesianPower do
    l:= [#x.j $j=1..op(S, 2)];
    return(solvelib::VectorImageSet(insert(l), l, [op(S, 1) $op(S, 2)]))
  end_case;
  
  FAIL
end_proc: