
// solvelib::solve_intersect

// compute the intersection of sets in the *mathematical* sense
// i.e., {a} intersect {b} equals {} only if a<>b can be proven



solvelib::solve_intersect:=
proc()
  local tbl: DOM_TABLE, res, argv, i: DOM_INT, j: DOM_INT, k: DOM_INT,
  maxeffort, S, T, unevaluated_intersections;
  save MAXEFFORT;
  
begin
  if args(0) = 0 then
    return(C_)
  end_if;
  
  // flatten
  argv:= [op({args()} minus {C_})];
  if nops(argv) = 0 then
    return(C_)
  elif nops(argv) = 1 then
    return(argv[1])
  end_if;

  unevaluated_intersections:= {};
  argv:= map(argv, 
  proc(x)  
  begin 
    if type(x) = "_intersect" then 
       unevaluated_intersections:= unevaluated_intersections union {{op(x)}};
       op(x) 
    else 
       x 
    end_if
  end_proc);

  // remove duplicates
  argv:= [op({op(argv)})];
  
  if testargs() then
    if map({op(argv)}, testtype, Type::Set) <> {TRUE} then
      error("Arguments must be sets")
    end_if
  end_if;
  
  if contains(argv, {}) > 0 then
    return({})
  end_if;


  case nops(argv)
    of 0 do
      return(C_)
    of 1 do
      return(argv[1])
    of 2 do
      [S, T]:= argv;
      if _lazy_or(({S, T} minus op(unevaluated_intersections, i) = {}) $i=1..nops(unevaluated_intersections)) then
        // S intersect T has already been evaluated without success
        return(hold(_intersect)(S, T))
      end_if; 
      break
    otherwise
      maxeffort:= MAXEFFORT;
      MAXEFFORT:= 2*MAXEFFORT/nops(argv)^2;
      for i from 1 to nops(argv) do
        for j from i+1 to nops(argv) do
          if _lazy_or(({argv[i], argv[j]} minus op(unevaluated_intersections, k) = {}) $k=1..nops(unevaluated_intersections)) then
              //  has already been evaluated without success
             next
          end_if; 

          res:= solvelib::solve_intersect(argv[i], argv[j]);
          if type(res) <> "_intersect"  or {op(res)}<> {argv[i], argv[j]} then
            argv[i]:= res;
            delete argv[j];
            // only some of the possible steps have been used,
            // re-increase 
            MAXEFFORT:= maxeffort / ((i-1)*nops(argv) + j);
            return(solvelib::solve_intersect(op(argv)))
          end_if
        end_for
      end_for;
      return(hold(_intersect)(op(sort(argv))))    
  end_case;

  assert(nops(argv) = 2);


  if S = T then
    return(S)
  end_if;

  if MAXEFFORT > 100 then 
  if type(S) = "_union" then
    MAXEFFORT:= MAXEFFORT/nops(S);
    res:= map([op(S)], solvelib::solve_intersect, T);
    if contains(map(res, type), "_intersect") = 0 then
      return(solvelib::solve_union(op(res)))
    end_if;
    if contains({op(S)}, T) then
      return(T)
    end_if
  elif type(T) = "_union" then
    MAXEFFORT:= MAXEFFORT/nops(T);
    res:= map([op(T)], solvelib::solve_intersect, S);  
    if contains(map(res, type), "_intersect") = 0 then
      return(solvelib::solve_union(op(res)))
    end_if;
    if contains({op(T)}, S) then
      return(S)
    end_if
  end_if;

  if type(S) = "_minus" and op(S, 1) = C_ then
    return(solvelib::solve_minus(T, op(S, 2)))
  elif type(T) = "_minus" and op(T, 1) = C_ then
    return(solvelib::solve_minus(S, op(T, 2)))
  end_if;
  
  end_if;

  if S::dom::_intersect <> FAIL or T::dom::_intersect <> FAIL then
    return(S intersect T)
  end_if; 
  
  tbl:= solvelib::intersectTable;
  
  if contains(tbl, type(S), type(T)) then
    tbl[type(S), type(T)](S, T)
  elif contains(tbl, type(T), type(S)) then
    tbl[type(T), type(S)](T, S)
  else
    hold(_intersect)(S, T)
  end_if
  
end_proc:


solvelib::intersectTable:=
table(
      (DOM_SET, DOM_SET) =
      proc(T, S)
        local res, s, t, possible, pw, maxeffort, nopsS;
        save MAXEFFORT;
      begin
        res:= S intersect T;
        pw:= {};
        S:= S minus res;
        T:= T minus res;
        if (nopsS:= nops(S)) > 0 and nops(T) > 0 then
          maxeffort:= MAXEFFORT;
          MAXEFFORT:= MAXEFFORT/nopsS/nops(T)/2;
          for s in S do
            possible:= {};
            for t in T do
              case is(s=t)
                of TRUE do
                  if length(s) <= length(t) and
                    not contains({DOM_COMPLEX, DOM_FLOAT}, type(t)) then
                    res:= res union {s}
                  else
                    res:= res union {t}
                  end_if;
                  S:= S minus {s};
                  T:= T minus {t};
                  break
                of UNKNOWN do
                  possible:= possible union {t}
                  // of FALSE: do nothing
               end_case;
             end_for;
             if possible <> {} then
               MAXEFFORT:= MAXEFFORT/nopsS/2;
               pw:= pw union
               piecewise([s in possible, {s}], [not s in possible, {}])
             end_if
          end_for;
          res union pw
      else
          res
      end_if
      end_proc, 


      (DOM_SET, "solve") =
      proc(S, T)
        local x, eq, a, eq2, operands, maxeffort;
        save MAXEFFORT;
      begin
        assert(S <> {}); // should have been caught above

        if MAXEFFORT < 100 then
          return(hold(_intersect)(S, T))
        end_if;

        if type((x:= op(T, 2))) = DOM_IDENT then
          eq:= op(T, 1);
          operands:= [];
          if testtype(eq, Type::Boolean) = FALSE then
            eq:= (eq = 0)
          end_if;
          maxeffort:= MAXEFFORT/2;
          MAXEFFORT:= MAXEFFORT/nops(S);
          for a in S do
            // include a in the result iff it is a solution
            if traperror((eq2:= evalAt(eq, x = a))) <> 0 then
              // a is not a solution
              next
            end_if;
            operands:= operands.[piecewise([eq2, {a}], [not eq2, {}])];
          end_for;
          MAXEFFORT:= maxeffort;
          operands:= select(operands, _unequal, {});
          return(_union(op(operands)))  
        end_if;
        hold(_intersect)(S, T)
      end_proc,

      (DOM_SET, "_minus") =
      proc(S, T)
        local A, B, res;
        save MAXEFFORT;
      begin
        if MAXEFFORT < 100 then
          return(hold(_intersect)(S, T))
        end_if;

        A:= op(T, 1);
        B:= op(T, 2);
        // S intersect (A minus B) = (S intersect A) minus B
        MAXEFFORT:= MAXEFFORT/2;
        if type((res:= solvelib::solve_intersect(S, A))) <> "_intersect" then
          solvelib::solve_minus(res, B)
        else
          hold(_intersect)(S, T)
        end_if 
      end_proc,
      
      ("_minus", "_minus") =
      proc(S, T)
      begin
        if op(S, 1) = op(T, 1) then
          return(op(S,1) minus (op(S, 2) union op(T, 2)))
        end_if;
        hold(_intersect)(S, T)
      end_proc


      ):

