//   


// solvelib::isFinite

/* tests whether the input is a finite set or not */


solvelib::isFinite:=
proc(S)

begin
  if S::dom::isFinite<>FAIL then
    return(S::dom::isFinite(S))
  end_if;

  case type(S)
    of DOM_SET do
      return(TRUE)
    of RootOf do
      // the set of solutions is finite iff at least one coefficient
      // does not equal zero
      is(_or(map(coeff(op(S,1), [op(S,2)]), _unequal, 0)));
      break
    of "_union" do
      _and(map(op(S), solvelib::isFinite));
      break
    of "_intersect" do
      _or(map(op(S), solvelib::isFinite)) or UNKNOWN;
      break
    of "_minus" do
      case solvelib::isFinite(op(S,1))
        of TRUE do
          return(TRUE)
        of FALSE do
          if solvelib::isFinite(op(S,2))=TRUE then
            return(FALSE)
          end_if;
      end_case;
      UNKNOWN;
      break
    otherwise
      UNKNOWN
  end_case
end_proc:


