/*--
	solvelib::solve_islinear

	Returns FALSE if sys is not a linear system with respect to 
	unk, otherwise sys where all equalities a=b have been replaced 
	by a-b and all 0 equations have been deleted.
--*/

/*  old version
solvelib::solve_islinear := proc(sys,unk)
local eq,u,l,newsys;
begin
   l:=[op(unk)];
   newsys:={};
   for eq in sys do
      if type(eq)="_equal" then eq:=op(eq,1)-op(eq,2) end_if;
      for u in unk do
         if type(u)=DOM_FUNC_ENV then error("cannot solve for ".expr2text(u)) end_if;
         if not testtype(eq,Type::PolyExpr(u)) then return(FALSE) end_if
      end_for;
      if degree(eq,l)>1 then return(FALSE) end_if;
      newsys:=newsys union {eq};
   end_for;
   newsys
end_proc:
*/


// This version should be much faster, at least for sparse systems,
// where the overhead of checking linearity matters.

solvelib::solve_islinear :=
proc(sys, unk)
  local eq,u,ivars;
begin
  // what type of unknowns can occur?
  case type(unk)
    of DOM_SET do break;
    of DOM_LIST do unk:= {op(unk)}; break;
      // of WhatEver do unk:= {..}; break;
  end_case;
  // do not build up newsys := newsys union {neweq}, this
  // is too slow. Instead:
  sys:= map(sys, eq -> if type(eq)="_equal" then
                         op(eq,1)-op(eq,2)
                       else eq
                       end_if);
  for eq in sys do
    if contains(map(unk, type), "_index") then
      ivars:= numeric::indets(eq) intersect unk
    else
      ivars:= indets(eq) intersect unk
    end_if;
    for u in ivars do
      // type(u) = DOM_FUNC_ENV ????
      if type(u)=DOM_FUNC_ENV then
        error("cannot solve for ".expr2text(u))
      end_if;
      if indets(diff(eq, u)) intersect ivars <> {} then
        return(FALSE)
      end_if;
    end_for;
  end_for;
  sys
end_proc:

/* end of file */
