

solvelib::matchmult:=
proc(Lhs:"_mult", Rhs, x, options)
  local u, v, p, q, C1, C2, k, l, f, t, n, Y, S, pw;
begin
  pw:=if options[IgnoreSpecialCases] then
  	  solvelib::ignoreSpecialCases
      else
        piecewise::new
      end_if;


  
  // handle special case f(x)^C1 * exp(C2*f(x)^k) = Rhs
  // (lambertW case)

  [u, v, p]:= split(Lhs, fctor-> type(fctor) = "exp");
  assert(p=1);
  u:= combine(u, exp);
  if type(u) = "exp" then
    p:= op(u);
    // Lhs = exp(p) * v
    if type(p)="_mult" then
      [p, C2, q] := split(p, has, x);
      assert(q=1);
    else
      C2:=1
    end_if;
    // now Lhs = exp(p*C2) * v 
    
    if type(v)="_power" and not has(op(v,2), x) then
      C1:= op(v, 2);
      v:= op(v, 1)
    else
      C1:= 1
    end_if;
    // now Lhs = exp(p*C2) * v^C1

    // find out whether p is a power of v
    if p = v then
      k:= 1
    elif type(p) = "_power" and op(p, 1) = v then
      k:= op(p, 2);
      p:= op(p, 1)
    else
      k:= FAIL
    end_if;
     // now k = FAIL or Lhs = exp(v^k * C2) * v^C1
    
    if type(k) = DOM_INT then
      // we are able to justify exp(t)^k = exp(k*t) to solve this
    
      // solve v^C1 * exp(C2*v^k) = Rhs, then solve v(x) = v0 for each sol. v0
      t:= genident();
      n:= genident();
     // S:= solve(t^C1 = Rhs, t, options);
      if options[Real] then
        // if Rhs represents zero, we may factor.
        // Otherwise v cannot be zero.
        // I. If v is positive, the exists a real number t with v=exp(t).
        // Our equation becomes
        // exp(C1*t) * exp(C2*exp(k*t)) = Rhs
        // which is impossible for Rhs <= 0; for Rhs >= 0, we have
        // C1*t + C2*exp(k*t) = ln(Rhs), which is done by matchplus
        // II. v can only be negative if C1 is an integer
        // With y=-v, we get
        // y^C1 * exp(C2*(-1)^k*y^k) = (-1)^C1*Rhs
        // as explained above, this has a solution if (-1)^C1*Rhs is positive
        // let y=exp(t)
        // then the equation becomes
        // exp(C1*t) * exp(C2*(-1)^k*exp(k*t)) = (-1)^C1*Rhs
        // for Rhs positive, C1 even, we arrive at
        // C1*t + C2*(-1)^k*exp(k*t) = ln(Rhs)
        // for Rhs negative, C1 odd, we arrive at
        // C1*t + C2*(-1)^k*exp(k*t) = ln(-Rhs)
        
        f:= pw
            (
             [Rhs > 0, 
              exp(solvelib::isolate(C1*t + C2*exp(k*t), ln(Rhs), t, options))
              ],
             [Rhs <0 and (C1 + 1)/2 in Z_,
              -exp(solvelib::isolate(C1*t + C2*(-1)^k*exp(k*t), ln(-Rhs), t,
                                    options))
              ],
             [Rhs < 0 and C1/2 in Z_,
              -exp(solvelib::isolate(C1*t + C2*(-1)^k*exp(k*t), ln(Rhs), t,
                                    options))
              ]
             [Rhs = 0, solvelib::isolate(t^C1, 0, t, options)]
             );
        f:= subs(f, hold(exp) = exp::simplify@exp);
        return(solvelib::preImage(v, x, f, options))
      end_if; // options[Real]
      // Real =FALSE; return all complex solutions:
      // with v = exp(t), we get
      // v^C1 * exp(C2*v^k) = Rhs 
      // exp(C1*ln(v)) * exp(C2*v^k) = Rhs
      // C1*ln(v) + C2*v^k = ln(Rhs) + 2*l*PI*I (unless Rhs=0)
      // C1*t + C2*exp(k*t) = ln(Rhs) + 2*l*PI*I
      
      return(pw
             ([Rhs <> 0 and C1 <>0,
               solvelib::preImage
               (v, x,
                simplify(Dom::ImageSet
                         (exp(-(-ln(Rhs)+
                                C1/k*lambertW
                                (n , C2*k/C1*exp((ln(Rhs)+2*I*PI*t)*k/C1))-
                                2*I*PI*t)/C1),
                          [n, t], [Z_, Z_])),
                options
                )
               ],
              // since we have handled Rhs = 0 before, we are just
              // left with the case that Rhs is a symbolic expression
              // that represents zero
              [Rhs = 0, solvelib::isolate(Lhs, 0, x, options)],
              // C1 = 0: the equation is really exp(C2*y^k) = Rhs
              [C1 = 0, solvelib::isolate(exp(C2*x), Rhs, x, options)]))
       elif k <> FAIL and not has(k, x) then      
      // Lhs = exp(C2* v^k) * v^C1
      // write this as 
      // exp(C2 * exp(k * ln(v))) * exp(C1 * ln(v))
      // = exp(  C2*exp(k*ln(v)) + C1*ln(v))
      // thus 
      // C2*exp(k*ln(v)) + C1 * ln(v)  = ln(Rhs) + 2*l*PI*I  (l in Z_)
      // thus Y = ln(v) must solve 
      // C2*exp(k*Y) + C1 * Y = ln(Rhs) + 2*l*PI*I
      Y:= solvelib::getIdent(C_, indets({Lhs, Rhs}));
      l:= solvelib::getIdent(Z_, indets({Lhs, Rhs}));
      S:= pw([Rhs = 0, solvelib::isolate(Lhs, 0, x, options)],
             [Rhs <> 0, solvelib::Union(solvelib::isolate(C2*exp(k*Y) + C1*Y, ln(Rhs) + 2*l*PI*I, Y, options), l, Z_)]);
      return(solvelib::preImage(ln(v), x, S, options))
    end_if; // type(k) = DOM_INT
    
  end_if; // type(u) = "exp"  

  // yet another lambertW case
  // C1*f(x)*exp(C2*f(x)) = Rhs
  [u, C1, v]:= split(Lhs, has, x);
  [u, f, v]:= split(u, a -> (type(a) = "exp"));
  if type(u) = "exp" and not has((C2:= op(u)/f), x) then
    if options[Real] then
      return
      (solvelib::preImage
       (f, x,
        pw([Rhs <> 0 and Rhs*C2/C1 >= 0,
                   {lambertW(0, Rhs*C2/C1)/C2}],
                  [Rhs <> 0 and Rhs*C2/C1 in Dom::Interval(-exp(-1), 0),
                   {lambertW(0, Rhs*C2/C1)/C2, lambertW(-1, Rhs*C2/C1)/C2}],
                  [Rhs <> 0 and Rhs*C2/C1 <= -exp(-1),
                   {}],
                  [Rhs = 0,
                   {0}]),
        options)
       )
    else
      return
      (solvelib::preImage
       (f, x,
        pw([Rhs <> 0,
                   Dom::ImageSet(
                    (Rhs/C1)/(C2*(Rhs/C1))
                      *lambertW(k, C2*(Rhs/C1)),
                    k,
                    Z_)],
                 [Rhs = 0,
                  {0}]),
       options)
       )
     end_if;
   end_if;
   
   // second subcase. We have Lhs = C1*f(x)*exp(t(x)) where t = op(u, 1)
     // if t(x) - f(x) is a constant C2, then we have to solve 
     // f(x) * exp(f(x) + C2) = Rhs/C1
     // that is, 
     // f(x) * exp(f(x)) = Rhs/C1/exp(C2)
     // f(x) = lambertW(k, Rhs/C1/exp(C2))
   t:= op(u, 1);
   C2:= t - f;
   if not has(C2, x) then       
     return(piecewise(
     [Rhs = 0, solvelib::isolate(f, 0, x, options)],
     [Rhs <> 0, solvelib::preImage(f, x, Dom::ImageSet(lambertW(#k, Rhs/C1/exp(C2)), #k, Z_), options)]
     ))
   end_if;  
   
   FAIL
 end_proc:
 // end of file
 
