

solvelib::matchplus:=
proc(Lhs, Rhs, x, options)
  local C1, C2, C3, u, v, p, q, a, b, f, k, n, i, pw, newlhs;
begin  
   pw:=if options[IgnoreSpecialCases] then
        solvelib::ignoreSpecialCases
      else
        piecewise::new
      end_if;
  
  // handle C1*f(x)^n + C2 * ln(C3*f(x)^k) = Rhs  (LambertW case)
  [u, v, p] := split(Lhs, hastype, "ln");
  assert(p = 0);
  if type(u) = "_mult" then
    [p, C2, q] := split(u, has, x);
    assert(q = 1);
  else
    C2:= 1;
    p:= u
  end_if;
  if type(p) = "ln" then
    p:= op(p);
    if type(p) = "_mult" then
      [p, C3, q]:= split(p, has, x);
      assert(q=1);
    else
      C3:=1
    end_if;
        
    if type(p) = "_power" and not has(op(p, 2), x) then
      a:= op(p, 1);
      k:= op(p, 2)
    else
      a:= p;
      k:= 1
    end_if;
    if type(v) = "_mult" then
      [p, C1, q] := split(v, has, x);
      assert(q = 1)
    else
      C1 := 1;
      p  := v
    end_if;

    if type(p) = "_power" and not has(op(p, 2), x) then
      b:= op(p, 1);
      n:= op(p, 2)
    else
      b:= p;
      n:= 1
    end_if;

    if a = b then
      if k=1 and n=1 then
        if options[Real] then
           return(
               pw([C2 <> 0 and C1/C2/C3*exp(Rhs/C2) >= -exp(-1),
                          {C2/C1*lambertW(0, C1/C2/C3*exp(Rhs/C2))}],
                         [C2 <>0 and C1/C2/C3*exp(Rhs/C2) < -exp(-1),
                          {}],
                          [C2 = 0, solvelib::isolate(C1*a, Rhs, x, options)]
                          )
               )
        elif is(C1/C3 in R_ and C2 in R_ and C2 <>0 and Rhs in R_, Goal = TRUE) then
          // special case, requested by Kai: prefer to express the solution
          // in terms of lambertW if possible
          return({exp(-lambertW(0, C1/C2/C3 * exp(Rhs/C2)))
                        *exp(Rhs/C2)/C3})
        else
          return
          (
           solvelib::preImage
           (a, x,
            pw([  C2 <> 0 and Re(Rhs) <= -1 and Im(Rhs) = PI and
                  exp(-wrightOmega(ln(C1/C2/C3)+(Re(Rhs)-I*PI)/C2))
                       *exp(Rhs/C2)/C3 in R_,
                       {exp(-wrightOmega(ln(C1/C2/C3)+Rhs/C2))
                        *exp(Rhs/C2)/C3,
                        exp(-wrightOmega(ln(C1/C2/C3)+(Re(Rhs)-I*PI)/C2))
                        *exp(Rhs/C2)/C3}],
                      [C2 <> 0 and (Re(Rhs) <= -1 and Im(Rhs) = PI and
                       not exp(-wrightOmega(ln(C1/C2/C3)+(Re(Rhs)-I*PI)/C2))
                       *exp(Rhs/C2)/C3 in R_
                       or Re(Rhs) > -1 or abs(Im(Rhs)) <> PI),
                       {exp(-wrightOmega(ln(C1/C2/C3)+Rhs/C2))
                        *exp(Rhs/C2)/C3}],
                      [C2 <> 0 and Re(Rhs) <= -1 and Im(Rhs) = -PI,
                       {}], 
                      [C2 = 0, {Rhs/C1}] 
                       ),
            options)
           )
        end_if
      elif is(k in Z_ and n in Z_) = TRUE and
        not options[Real] then
          genident();
          return(solvelib::preImage
                 (a, x,
                  pw(
                         [k=0, solvelib::isolate(C1*x^n, Rhs - C2*ln(C3), x, options)],
                         [n=0, solvelib::isolate(C2*ln(C3*x^k), Rhs - C1, x, options)],
                         [C2=0, solvelib::isolate(C1*x^n, Rhs, x, options)],
                         [C1=0 and C2<>0, solvelib::isolate(ln(C3*x^k), Rhs/C2, x, options)],
                         [k<>0 and n<>0 and C2 <> 0 and C1 <> 0 and (Re(Rhs) > -1 or Im(Rhs) <> -PI),
                             {exp(-wrightOmega(ln(C1*n/C2/C3^(n/k)/k)+
                                               n*Rhs/C2/k)/n)
                              *exp(Rhs/C2/k)/C3^(1/k)}],
                            [k <> 0 and n<>0 and C2 <> 0 and C1 <> 0 and(Re(Rhs) <= -1 and Im(Rhs) = -PI),
                             {}]),
                             options
                             )
                 )
      end_if
    elif not has((v:= C1*b^n - C3*a^k), x) then
      // we have to solve C1*b^n + C2*ln(C3*a^k) = Rhs
      // write this as C3*a^k + C2*ln(C3*a^k) = Rhs - v
      return(solvelib::preImage
             (C3*a^k, x,
              solvelib::isolate(x + C2*ln(x), Rhs - v, x, options), 
              options
              )
             )
    elif not has((v:= b^n - a^k), x) then
      // we have to solve C1*b^n + C2*ln(C3*a^k) = Rhs
      // write this as C1*a^k + C2*ln(C3*a^k)    = Rhs - C1*v
      return(solvelib::preImage
             (a^k, x,
              solvelib::isolate(C1*x + C2*ln(C3*x), Rhs - C1*v, x,
                                options)
              )
             )
    end_if; // a = b
  end_if; // type(p) = "ln"


// heuristic to reduce equations in ln(x) and x to equations in u and exp(u)
// write u:= ln(x)
// if the resulting equation can be solved for y and S is the set of solutions, then solve ln(x) in S  
  
if has(Lhs, ln(x)) then
  u:= genident("u");
  newlhs:= subs(Lhs, ln(x) = u, x = exp(u));
  v:= solvelib::isolate(newlhs, Rhs, u, options);
  if type(v) <> "solve" then
    return(solvelib::preImage(ln(x), x, v, options))
  end_if;  
end_if;  



// handle C1*f(x) + C2* exp(C3*f(x)) = Rhs  (second LambertW case)
// write a = f(x)


  [u, v, p] := split(Lhs, hastype, "exp");
  // u = C2*exp(C3*f(x)), v = C1*f(x)
  assert(p = 0);
  // now let p = exp(C3*f(x))
  if type(u) = "_mult" then
    [p, C2, q] := split(u, has, x);
    assert(q = 1);
  else
    C2:= 1;
    p:= u
  end_if;
  if type(p) = "exp" then
    // let a = C3*f(x)
    a:= op(p);
    if type(v) = "_mult" then
      // let b = f(x)
      [b, C1, q] := split(v, has, x);
      assert(q = 1)
    else
      C1 := 1;
      b  := v
    end_if;
      
    if not has(b/a, x) then
      // write v = C1*f(x) as (C1*b/a) b =: C1 * b
      // such that the argument of exp and the factor b become equal
      // we have to handle the case a=0 separately 
      C1:= C1 * (b/a);
      k:= genident();
      if not options[Real] then
        return(pw([a/b <> 0, solvelib::preImage
                             (a, x, Dom::ImageSet
                                   (- (C1*lambertW(k, C2*exp(Rhs/C1)/C1) - Rhs)/C1,
                                   k, Z_), 
                                   options)],
                  [a/b = 0, solvelib::isolate(v + C2, Rhs, x, options)]
                  )
               )
      else
        return(pw
               ([a/b = 0, solvelib::isolate(v + C2, Rhs, x, options)],
                [a/b <> 0 and C2*exp(Rhs/C1)/C1 >= -exp(-1),
                 solvelib::preImage
                 (a, x,
                  Dom::ImageSet
                  (
                   Rhs/C1-lambertW(`#k`, C2*exp(Rhs/C1)/C1),
                   `#k`,
                   pw([C2*exp(Rhs/C1)/C1 < 0,
                              {-1, 0}],
                      [C2*exp(Rhs/C1)/C1 >= 0,
                              {0}])),
                    options)],
                [a/b <> 0 and C2*exp(Rhs/C1)/C1 < -exp(-1),
                 {}])
               )
      end_if
    end_if;
  end_if;


// third lambertW case
// C1*f(x)^n+C2*exp(C3*f(x)) = 0


  if iszero(Rhs) then
    [u, v, p] := split(Lhs, hastype, "exp");
    assert(p=0);
    if type(v) = "_mult" then
      [f, C1, p]:= split(v, has, x)
    else
      C1:= 1; f:= v
    end_if;
    // now Lhs = u + C1*f where u contains exp(..)
    if not options[Real] and
      type(f) = "_power" and type((n:= op(f, 2))) = DOM_INT then
      f:= op(f, 1);
      if type(u) = "_mult" then
        [u, C2, p]:= split(u, has, x)
      else
        C2:= 1
      end_if;
      // now Lhs = C1*f^n + C2*u
      if type(u) = "exp" and not has((C3:= op(u, 1)/f), x) then
        // Lhs = C1*f^n + C2*exp(C3*f)
        return(_union
               (_seqgen
                (
                 solvelib::preImage
                 (f, x,
                  Dom::ImageSet
                  (
                   -n*lambertW(#k, sign(n)*(-1)^(sign(n)*n)*exp(2*PI*I*i/n)
                               *(-C2*C3^n/C1)^(sign(n)/n)/n)/C3,
                   #k,
                   Z_),
                  options),
                 i,
                 1..abs(n)))
               )

      end_if;
    end_if;
  end_if;
  FAIL
end_proc:
// end of file
