/*  Revision: 1.8 $ */



// solvelib::solve_minus(S,T)

// computes S minus T correctly, even if S and T contain
// parameters

solvelib::solve_minus:=
proc(S, T, options = solvelib::getOptions():DOM_TABLE)
  local constS, paramS, constT, paramT, fconstT, pw, res, res2, i, myin,
  isConstant: DOM_PROC;
  save MAXEFFORT;
  
begin

  // myin: expresses x in S in a way the property mechanism can handle,
  // even if x is a matrix and S is a set of matrices
  myin:=
  proc(x, S: DOM_SET)
    local equ: DOM_PROC, a;
  begin
    if type(x) <> matrix then
      return(x in S)
    end_if;

    // express x=v without using matrices
    equ:=
    proc(v)
      local i:DOM_INT;
    begin
      if type(v) <> matrix or
      nops(v) <> nops(x) then
        FALSE
      else  
        _and(op(v, i) = op(x, i) $i=1..nops(x))
      end_if
    end_proc;
    
    _or(equ(a) $a in S)
  end_proc;

  
  isConstant:=
  proc(u)
  begin
    if type(u) = DOM_LIST or type(u) = matrix then
      bool(map({op(u)}, type@float) minus {DOM_COMPLEX, DOM_FLOAT} = {})
    else
      contains({DOM_COMPLEX, DOM_FLOAT}, type(float(u)))
    end_if
  end_proc;

  // simple case
  
  if T={} or S={} then
    return(S)
  end_if;

  if S = T then 
    return({})
  end_if;

  if S::dom::_minus <> FAIL then
    return(S::dom::_minus(S,T))
  elif T::dom::_minus <> FAIL then
    return(T::dom::_minus(S,T))
  end_if;

  // try some distributive laws
  if type(S) = "_union" or type(S) = "_intersect" then
    MAXEFFORT:= MAXEFFORT/nops(S);
    res:= map(S, solvelib::solve_minus, T, options);
    res2:= hold(_minus)(S, T);
    if length(res) <= length(res2) then
      return(res)
    else
      return(res2)
    end_if
  end_if;

  // in S minus (T1 union T2 ... union Tn), try to compute some
  // S minus Ti, then start over with
  // (S minus Ti) minus (T1 union ... T_{i-1} union T_{i+1} ... union Tn)
  if type(T) = "_union" then
    for i from 1 to nops(T) do
      res:= solvelib::solve_minus(S, op(T, i));
      if type(res) <> "_minus" then
        if nops(T) = 2 then
          if i = 1 then
            return(solvelib::solve_minus(res, op(T, 2)))
          else
            assert(i=2);
            return(solvelib::solve_minus(res, op(T, 1)))
          end_if;
        end_if;
        return(solvelib::solve_minus(res,
                                       _union
                                       (op(T, 1..i-1), op(T, i+1..nops(T)))
                                       )
                 );
      end_if
    end_for
  end_if;

  // (A minus B) minus C -> A minus (B union C)
  if type(S) = "_minus" then
    return(solvelib::solve_minus(op(S, 1),
                                 solvelib::solve_union(op(S, 2), T) )
           )
  end_if;
 
  // A minus (B minus C) -> A if A subset C
  if type(T) = "_minus" then
    if S subset op(T, 2) = TRUE then
      return(S)
    end_if
  end_if;
  
  
  if type(S)<>DOM_SET or type(T)<>DOM_SET then
    return(hold(_minus)(S,T))
  end_if;

  pw:=if options[IgnoreSpecialCases] then
        solvelib::ignoreSpecialCases
      else
        piecewise
      end_if;

  // now S and T are sets
  // split into constant elements and elements with parameters
  
  paramS:=split(S, isConstant);
  constS:=op(paramS,1);
  paramS:=op(paramS,2);

  paramT:=split(T, isConstant);
  constT:=op(paramT,1);
  paramT:=op(paramT,2);

  fconstT:= map(constT, float);
  
  // S = constS union paramS
  // T = constT union paramT
  // to compute: S minus T = constS minus (constT union paramT) union
  //                         paramS minus T
  //                       = (constS minus constT) minus paramT union
  //                         paramS minus T

  
  constS:= select(constS, u-> not contains(fconstT, float(u)));

  map(constS, u -> pw([myin(u, paramT), {}], [not myin(u, paramT), {u}]));
  constS:=_union(op(%));
  
  paramS:=map(paramS, u -> pw([myin(u, T), {}], [not myin(u, T), {u}]));
  paramS:=_union(op(%));
  
  constS union paramS
    
end_proc:

// end of file
