/*    */

/*--
	solvelib::solve_poly --  solve a polynomial

	solve_poly( p, x, options )

	p  : polynomial
	x  : indeteminate
	

--*/

solvelib::solve_poly :=
proc(p: DOM_POLY, x: DOM_IDENT): Type::Set

local
  d, l, s,
  i: DOM_INT,
  j: DOM_INT,
  multi: DOM_BOOL,
  hasfloat: DOM_BOOL,
  options: DOM_TABLE;
  
begin
  
  options:= solvelib::getOptions(args(3..args(0)));
  userinfo(3, "solve_poly called with ".expr2text(p));
  userinfo(10, "solving for ".expr2text(x));
  userinfo(10, "Options are ".expr2text(options));
  multi:= options[Multiple];
  
  hasfloat:= stdlib::hasfloat(op(p,1));
  
  d:=degree(p,x);
  if d<=1 then
    userinfo(10,  "poly has small degree, do not try to factor");
    return(solvelib::solve_poly_irred(p, x, options))
  else /* d >=2 */
    if hasfloat then
      s:= mapcoeffs(p, float);
      if {op(map(poly2list(s), domtype@op, 1))}
        minus {DOM_FLOAT, DOM_COMPLEX} = {} then
        // no symbolic coefficients remain
        // Use numeric solver
        if multi then
          return(Dom::Multiset(op(numeric::polyroots(s))))
        else
          return({op(numeric::polyroots(s))})
        end_if
      end_if;
    end_if;
     


    if d > 2 and nterms(p) = 2 and iszero(coeff(p, 0)) then
      return(solvelib::twoTerms(p, x, options))
    end_if;  


    userinfo(1,"trying to factor polynomial of degree ".d);
    userinfo(2,"polynomial is ".expr2text(p));
    // do not try factor with field extensions
    // because there could be many irrational
    // coefficients
    if (d > 10 and nterms(p) = 2 and not iszero(coeff(p, 0))) 
       or 
       traperror((
       l:= factor(p, MaxDegree = 1)),
       MaxSteps = 5) <> 0 then
       // consider l as irreducible
       l:= [1, p, 1]
    else
       assert(domtype(l) = Factored);
       l:= Factored::convert_to(l, DOM_LIST);
       userinfo(5, "Factorization is ".expr2text(l));
    end_if;      


    assert(type(l) = DOM_LIST);

    // factors of a polynomial cannot have negative multiplicity
    assert(_and (l[2*i+1] >= 0 $i=1..nops(l) div 2));
    
    // multiply by lcm of denominators
    // this is an equivalence, and it is the best way
    // to express the implicit assumption that the denominators
    // of the input are nonzero
    s:= denom(l[1]);
    for j from 2 to nops(l) step 2 do
      l[j]:= multcoeffs(l[j], 1/s)
    end_for;

    if multi then
      s:= Dom::Multiset()
    else
      s:= {}
    end_if;
      
    for i from 1 to nops(l) div 2 do
      userinfo(4, "Processing ".expr2text(i)."th irreducible factor");
      assert(l[2*i+1] >= 0);  
      if multi then
        s:= s union
        (Dom::Multiset)::_union(
                 solvelib::solve_poly_irred(poly(l[2*i],[x]), x, options)
                                $l[2*i+1]);
        
      else
        s:=s union
            _union(solvelib::solve_poly_irred(poly(l[2*i],[x]), x, options))
      end_if;
    end_for;

    return(s)
  
  end_if;

  // NOT REACHED
  assert(FALSE)
end_proc:

/* end of file */
