/*--
        solvelib::solve_poly4
--*/

solvelib::solve_poly4 :=
proc(p,x)
    local b,q,r,t1,t2,t3,t4,t5,t8,t11,t14,t15,t16,
          t17,t18,t19,t20,t21,t22,t23,t24,t25,t26,t27,t28,t29,t31,
          t33,t34,t36,t38,t39,t40,t42,t44,X1,X2,X3,X4,c,a,
          cubicResolvent, y,
          numeric_mode, result, options, s;
begin
   assert(degree(p) = 4);

   options:=solvelib::getOptions(args(3..args(0)));
   if options[Multiple]=TRUE then
     s:= S -> if type(S) = piecewise then
                piecewise::fillCases(
                piecewise::extmap(S, Dom::Multiset), {})
              elif S = undefined then
                {}
              else
                Dom::Multiset(args())
              end_if
   else
     s:= S -> if type(S) = piecewise then
                piecewise::fillCases(
                piecewise::extmap(S, DOM_SET), {})
              elif S = undefined then
                {}
              else
                {args()}
              end_if
   end_if;

  
  
   userinfo(2, "entering degree 4 poly solver");
   if stdlib::hasfloat(p) then
     p:= mapcoeffs(p, float);
     numeric_mode:= TRUE;
     // if all coeffs are floats, this has been caught in solve_poly above
     assert({op(map(poly2list(p), domtype@op, 1))} minus {DOM_FLOAT, DOM_COMPLEX} <> {});
     t15:=3.0^(1/2); t33:=6.0^(1/2);
   else // there are no float entries
     numeric_mode:= FALSE;
     t15:=3^(1/2); t33:=6^(1/2);
   end_if:

   /* first make p monic */

   p:=multcoeffs(p,1/lcoeff(p)); 

   /* now p=x^4+b*x^3+c*x^2+d*x+e */

   /* Try to factorize p(x) 
     = (x^2+(a+sqrt(b))*x+c)*(x^2+(a-sqrt(b))*x+c)
     = x^4 + 2*a*x^3 + (a^2-b+2*c)*x^2 + 2*a*c*x + c^2  */
   a:=coeff(p,3)/2;
   if expand(coeff(p,1)^2)=expand(4*coeff(p,0)*a^2)
   then /* we can factorize */
      if iszero(a)
        then c:=sqrt(coeff(p,0))
        else c:=coeff(p,1)/2/a    //avoid sqrt, if possible
      end_if;
      b:=a^2+2*c-coeff(p,2);
      return(solvelib::solve_poly_irred(
                  poly(x^2+(a+sqrt(b))*x+c,[x]),x,options)
             union
             solvelib::solve_poly_irred(
                  poly(x^2+(a-sqrt(b))*x+c,[x]),x,options))
   end_if;

   /* main branch: Cardano formula for p(x) = x^4+2*a*x^3+c*x^2+d*x+e */
   /* make the change x=X-a/2 so that coeff of X^3 vanishes */
   a:=a/2:
   p:=p(x-a); 
   r:=expand(coeff(p,[x],0));
   q:=expand(coeff(p,[x],1));
   // poly p is not needed any more, so overwrite it!
   p:=expand(coeff(p,[x],2));

   /* now poly(X)=X^4+p*X^2+q*X+r */
   // where X = x-a


   if options[Real] then

     // the equation to solve is equivalent to
     // (X^2 + p + y)^2 = (p + 2*y)*X^2 - q*X + (p^2 - r + 2*p*y + y^2) (*)
     // where y may be arbitrary
     // let y be such that the right hand side is a square; then
     // y must be a root of the following polynomial (in real mode,
     // we choose a real one)

     
     cubicResolvent:=
     poly(q^2 - 4*p^3 +4*p*r +(-16*p^2 + 8*r)*x - 20*p*x^2 - 8*x^3, [x]);
   
     y:= solvelib::realRootCubic(cubicResolvent, x);
     // now the right hand side of (*) is (p+2*y)*(X - q/2/(p + 2*y))^2
     result:=
     piecewise([p + 2*y < 0, {}],
               [p + 2*y >=0,
     solve(x^2 + p + y - sqrt(p+2*y)*(x - q/2/(p + 2*y)), x, options)-a
     union solve(x^2 + p + y + sqrt((p+2*y))*(x - q/2/(p + 2*y)), x, options)-a
                ]
            );
     
            
   else
            
     t1:=r*p;
     t2:=q^2;
     t3:=p^2;
     t4:=t3*p;
     t5:=r^2;
     t8:=t3^2;
     t11:=t2^2;
     t14:=sqrt(128*t5*t3-256*t5*r-16*r*t8-144*t1*t2+27*t11+4*t2*t4);
     t16:=t14*t15;
     t17:=-4/3*t1+t2/2+t4/27+t16/18;  // must be <> 0
     t18:=t17^(1/3);
     t19:=p*t18;
     t20:=t18^2;
     t21:=-6*t19+9*t20+12*r+t3; // must be <>0
     t22:=sqrt(t21);
     t23:=t17^(1/6);   // must be <> 0
     t24:=1/t23;       // potential crash !!
     t25:=t22*t24;
     t26:=t19*t22;
     t27:=t22*t20;
     t28:=t22*r;
     t29:=t22*t3;
     t31:=sqrt(27*t2-72*t1+2*t4+3*t16);
     t34:=q*t31*t33;
     t36:=sqrt(-12*t26-9*t27-12*t28-t29-3*t34);
     t38:=t21^(1/4);   // must be <> 0
     t39:=1/t38;       // potential crash !!
     t40:=t36*t24*t39;
     t42:=sqrt(3*t34-12*t26-9*t27-12*t28-t29);
     t44:=t42*t24*t39;

     X1:= t25/6+t40/6; X2:= t25/6-t40/6;
     X3:=-t25/6+t44/6; X4:=-t25/6-t44/6;
     
     result:= s(X1-a,X2-a,X3-a,X4-a):

   end_if;
 
  
  if numeric_mode // there are both symbolic entries as well as floats
    then
    return(subs(map(result, float), float(0)=0))
  else
    return(result);
  end_if:

end_proc:

/* end of file */
