
/*
selectIndices(S, indices)

S - a solution in vector format
indices - list of integers [i_1, ..., i_k]

applies the mapping [a_1, ..., a_n] -> [a_{i_1}, ..., a_{i_k}]



*/

solvelib::selectIndices:=
proc(S: Type::Set, indices: DOM_LIST): Type::Union(Type::Set, DOM_FAIL)
  local
  selectFromList: DOM_PROC, toFree: DOM_SET,
  i: DOM_INT, result, options: DOM_TABLE, S1;

  save MAXEFFORT;
  
begin
  
  selectFromList:=
  proc(l: matrix)
    local i: DOM_INT;
  begin
    matrix([op(l, indices[i]) $i=1..nops(indices)])
  end_proc;


  case type(S)
    of piecewise do
      result:= piecewise::extmap(S, solvelib::selectIndices, indices);
      if has(result, FAIL) then
        return(FAIL)
      else
        return(result)
      end_if
    of DOM_SET do
    of Dom::ImageSet do
    of solvelib::VectorImageSet do
      return(map(S, selectFromList))  
    of "_union" do
      MAXEFFORT:= MAXEFFORT/nops(S);
      result:= map({op(S)}, solvelib::selectIndices, indices);
      if contains(result, FAIL) then
        return(FAIL)
      elif nops(result) = 1 then
        return(op(result, 1))
      elif nops(indices) = solvelib::dimension(S) then
        return(hold(_union)(op(result)))
      else
        return(_union(op(result)))
      end_if
    of "_intersect" do
      MAXEFFORT:= MAXEFFORT/nops(S);
      if nops(indices) = solvelib::dimension(S) then
        // just an index permutation
        result:= map({op(S)}, solvelib::selectIndices, indices);
        if contains(result, FAIL) then
          return(FAIL)
        else
          return(eval(op(S, 0))(op(result)))
        end_if
      end_if;
      userinfo(1, "Cannot select indices from intersections in general");
      return(FAIL)
    of "_minus" do
      if nops(indices) = solvelib::dimension(S) then
        // just an index permutation
        MAXEFFORT:= MAXEFFORT/2;
        result:= map([op(S)], solvelib::selectIndices, indices);
        if contains(result, FAIL) > 0 then
          return(FAIL)
        else
          return(result[1] minus result[2])
        end_if
      end_if;
      // we must not map to the operands. However, we may do this
      // if the second operand is a set S x C_^n, and we leave out components that are equal to C_ 
      MAXEFFORT:= MAXEFFORT/4;
      if type(op(S, 2)) = solvelib::VectorImageSet then
        S1:= solvelib::selectIndices(op(S, 2), select([$1..solvelib::dimension(S)], j -> (contains(indices, j) = 0)));
        if type(S1) = solvelib::cartesianPower and op(S1, 1) = C_ then 
      	  result:= map([op(S)], solvelib::selectIndices, indices);
          if contains(result, FAIL) > 0 then
            return(FAIL)
          else
            return(result[1] minus result[2])
          end_if
        end_if;  
      end_if;  
      userinfo(1, "Cannot select indices from set differences in general");
      return(FAIL)
    of "Union" do
      result:= solvelib::selectIndices(op(S, 1), indices);
      if result = FAIL then
        return(FAIL)
      else
        return(eval(subsop(S, 1 = result)))
      end_if
    of solvelib::cartesianPower do
      return(solvelib::cartesianPower(S::dom::base(S), nops(indices)))
    of "cartesianProduct" do
      // not implemented yet
      return(FAIL)
    of "solve" do
      if type(op(S, 2)) <> DOM_LIST then
        error("solution does not represent a vector set")
      end_if;
      options:= solvelib::getOptions(op(S, 3..nops(S)));
      options[VectorFormat]:= TRUE;
      toFree:= {$1..nops(op(S, 2))} minus {op(indices)};
      toFree:= {op(S, [2, i]) $i in toFree};
      result:= solve(op(S, 1), [op(S, [2, indices[i]]) $i=1..nops(indices)],
                     options);
      for i from 1 to nops(toFree) do
        result:= solvelib::Union(result, op(toFree, i), C_)
      end_for;
      return(result)
    of stdlib::Undefined do
      return(undefined)
  end_case;

  // default
  warning("Could not extract components from vector set of type ".
           expr2text(type(S)));
  FAIL
end_proc:

