
/*
   solvelib::solveIn(eq, x, S)

   returns the set of all x such that eq(x) is in S(x)
   cf. solvelib::preImage (where S must not depend on x)

*/

solvelib::solveIn:=
proc(eq, x, S, options: DOM_TABLE)
  local i: DOM_INT;
  save MAXEFFORT;
begin
  
  // handle vector sets
  if type(eq) = DOM_LIST or type(eq) = matrix then 
    return(hold(solve)(eq in S, x,
                     solvelib::nonDefaultOptions(options)))
  end_if;
                   
  if not testtype(eq, Type::Arithmetical) then
    error("_in: illegal first operand")
  end_if;  
                     
  if not contains(freeIndets(S), x) then
    return(solvelib::preImage(args()))
  end_if;

  if S::dom::solveIn <> FAIL then
    return(S::dom::solveIn(eq, x, S, options))
  end_if;
  
  case type(S)
    of DOM_SET do
      return(solve(_or(eq = op(S, i) $i=1..nops(S) ),
                   x,
                   options))
    of "_union" do
      MAXEFFORT:= MAXEFFORT/nops(S);
      return(_union(solvelib::solveIn(eq, x, op(S, i), options)
                    $ i = 1..nops(S)));
    of "_intersect" do
      MAXEFFORT:= MAXEFFORT/nops(S);
      return(_intersect(solvelib::solveIn(eq, x, op(S, i), options)
                        $ i = 1..nops(S)));
    of piecewise do
      return(solve(expand(eq in S), x, options))                    
    of Dom::Interval do
      // f(x) in (g(x), h(x)) iff f(x) > g(x) and f(x) < h(x)
      return(solve(expand(eq in S), x, options))
  end_case;
  
  return(hold(solve)(eq in S, x,
                     solvelib::nonDefaultOptions(options)))
end_proc:
