
solvelib::solve_union:=
proc()
  local argv, i, j, maxeffort, res, tbl, S, T;
  save MAXEFFORT;
begin

 // flatten
  argv:= {args()}; // removes duplicates
  argv:= [op(argv)];
  argv:= map(argv, x -> if type(x) = "_union" then op(x) else x end_if);

  argv:= select(argv, _unequal, {});
  
  if MAXEFFORT < 100 then
    case nops(argv)
      of 0 do
        return({})
      of 1 do
        return(argv[1])
      otherwise  
        return(hold(_union)(op(sort(argv))))
    end_case
  end_if;

  case nops(argv)
    of 0 do
      return({})
    of 1 do
      return(argv[1])
    of 2 do
      [S, T]:= argv;
      break
    otherwise
      maxeffort:= MAXEFFORT;
      MAXEFFORT:= 2*MAXEFFORT/nops(argv)^2;
      for i from 1 to nops(argv) do
        for j from i+1 to nops(argv) do
          res:= solvelib::solve_union(argv[i], argv[j]);
          if type(res) <> "_union" or {op(res)}<> {argv[i], argv[j]} then
            argv[i]:= res;
            delete argv[j];
            // only some of the possible steps have been used,
            // re-increase 
            MAXEFFORT:= maxeffort / ((i-1)*nops(argv) + j);
            return(solvelib::solve_union(op(argv)))
          end_if
        end_for
      end_for;
      return(hold(_union)(op(sort(argv))))    
  end_case;

 assert(nops(argv) = 2);


  if S = T then
    return(S)
  end_if;


  if type(S) = "_intersect" then
    MAXEFFORT:= MAXEFFORT/nops(S);
    res:= map([op(S)], solvelib::solve_union, T);
    if contains(map(res, type), "_union") = 0 then
      return(solvelib::solve_intersect(op(res)))
    end_if;
    if contains({op(S)}, T) then
      return(T)
    end_if
  elif type(T) = "_intersect" then
    MAXEFFORT:= MAXEFFORT/nops(T);
    res:= map([op(T)], solvelib::solve_union, S);
    if contains(map(res, type), "_union") = 0 then
      return(solvelib::solve_intersect(op(res)))
    end_if;
    if contains({op(T)}, S) then
      return(S)
    end_if
  end_if;
  
  if S::dom::_union <> FAIL or T::dom::_union <> FAIL then
    return(S union T)
  end_if; 
  
  tbl:= solvelib::unionTable;
  
  if contains(tbl, type(S), type(T)) then
    tbl[type(S), type(T)](S, T)
  elif contains(tbl, type(T), type(S)) then
    tbl[type(T), type(S)](T, S)
  else
    hold(_union)(S, T)
  end_if
  
end_proc:


solvelib::unionTable:=
table(
      (DOM_SET, DOM_SET) =
      _union,
     

      (DOM_SET, "solve") =
      proc(S, T)
        local Snew;
      begin
        if S={} then
          return(T)
        end_if;
        Snew:= solvelib::solve_intersect(S, T);
        if type(Snew) = DOM_SET then
          (S minus Snew) union T
        else
          S union T
        end_if;
      end_proc,
      
      
       

      (DOM_SET, "_minus") =
      proc(S, T)
        local A, B, res;
        save MAXEFFORT;
      begin
        A:= op(T, 1);
        B:= op(T, 2);
        // S union (A minus B) = S union (A minus (B minus S))
        MAXEFFORT:= MAXEFFORT/3;
        if type((res:= solvelib::solve_minus(B, S))) <> "_minus"
          and type((res:= solvelib::solve_minus(A, res))) <> "_minus"
          then
          return(solvelib::solve_union(S, res))
        end_if;
        // we cannot apply is to matrices
        S:= select(S, x-> _lazy_or(type(x) = matrix,
                                   not is(x in T, Goal = TRUE))
                   );
        if nops(S) = 0 then
          T
        else
          hold(_union)(S, T)
        end_if
      end_proc
      

      ):




