

/*
 solvelib::splitVectorSet(S, n)

 express S as S1 x ... x Sn, where the S_i are one-dimensional sets
 returns([S1, ..., Sn]) or FAIL

*/


solvelib::splitVectorSet:=
proc(S: Type::Union(Type::Set, DOM_FAIL), dimension):
  Type::Union(DOM_LIST, DOM_FAIL, piecewise)
  local
  pw: piecewise,
  i: DOM_INT,
  j: DOM_INT, v,
  vars: DOM_LIST,
  curvars: DOM_SET,
  usedvars: DOM_SET,
  sets: DOM_LIST,
  result: Type::Union(DOM_LIST, DOM_FAIL);
  
begin
  assert(args(0) = 1 or args(0) = 2);

  if S=FAIL then
    return(FAIL)
  end_if;

  if args(0) = 1 then
    dimension:= solvelib::dimension(S);
    if dimension = FAIL then
      return(FAIL)
    end_if
  end_if;

  assert(domtype(dimension) = DOM_INT and dimension >= 1);    

  if dimension = 1 then
    result:= [solvelib::vectorSetToNumberSet(S)];
    if result = [FAIL] then
      return(FAIL)
    else
      return(result)
    end_if
  end_if;
  case type(S)
    of DOM_SET do
      if nops(S) = 0 then
        return([{} $dimension])
      end_if;
      if nops(map(S, nops)) > 1 then
        // vectors of different dimension
        return(FAIL)
      end_if;
      result:= [map(S, op, i) $i=1..dimension];
      // we know that S must be a subset of the cartesian product of the
      // elements of results;
      // they are equal if they have the same number of elements
      if nops(S) = _mult(op(map(result, nops))) then
        return(result)
      else
        return(FAIL)
      end_if
    of piecewise do
      pw:= piecewise::extmap(S, solvelib::splitVectorSet, dimension);
      if not has(pw, FAIL) then
        return(pw)
      end_if;
      break
    of "solve" do
      // we can only split this if the variables occur in separate equations
      vars:= op(S, 2);
      assert(type(vars) = DOM_LIST);
      assert(type(op(S, 1)) = DOM_LIST);
      v:= map(op(S, 1), eq -> indets(eq) intersect {op(vars)});
      if  {op(map(v, nops))} <> {1} then
        // in some eq, there are two variables
        break
      end_if;
      return([solve(select(op(S, 1), has, vars[i]), vars[i]) $i=1..nops(vars)])
    of "cartesianProduct" do
      if map({op(S)}, solvelib::dimension) <> {1} then
        return(FAIL)
      else
        return([op(S)])
      end_if
    of "cartesianPower" do
      return([op(S,1) $op(S,2)])
    of solvelib::VectorImageSet do
      v:= expr(S);
      vars:= S::dom::variables(S);
      sets:= S::dom::sets(S);
      if nops(v) = 1 then
        return([Dom::ImageSet(op(v, 1), vars, sets)])
      else
        // try to recognize a cartesian product of image sets.
        // this will work if each variable occurs in exactly one component
        usedvars:= {}; // variables already used in a previous component
        result:= [];
        for i from 1 to nops(v) do
          curvars:= {op(vars)} intersect indets(op(v, i));
          if nops(curvars) = 0 then
              // component is constant, hence S_i = {v[i]}
            result:= result.[{op(v, i)}]
          else
            if usedvars intersect curvars <> {} then
              // some variable has occurred for a second time
              return(FAIL)
            end_if;
            result:= result.
                     [Dom::ImageSet
                      (op(v, i),
                       [op(curvars)],
                       [sets[contains(vars, op(curvars, j))]
                        $j=1..nops(curvars)])];
            usedvars:= usedvars union curvars;
          end_if
        end_for;
        return(result)
      end_if  
  end_case;
  FAIL
end_proc: