//   

/* solvelib::substituteBySet(a, x, S)

   given an object a that is not a set and contains the variable x,
   return the set of all objects that can be
   obtained by substituting some element of S for x, or FAIL

*/


solvelib::substituteBySet:=
proc(a, x: Type::Union(DOM_IDENT, DOM_LIST), S: Type::Set):
  Type::Union(Type::Set, DOM_FAIL)
  local newidents, l;
begin
  assert(args(0) = 3):
   
  if type(x) = DOM_LIST then
    return(solvelib::substituteByVectorSet(a, x, S))
  end_if;


  if S::dom::substituteBySet <> FAIL then
    return(S::dom::substituteBySet(args()))
  end_if;
  
  
  case domtype(S)
    of DOM_SET do
      return(map(S, proc(u)
                      local c;
                      begin
                        if traperror((c:= subs(a, x=u, EvalChanges))) = 0 then
                          c
                        end_if
                 end_proc))
    of DOM_EXPR do
      case type(S)
        of "solve" do
        of "_minus" do
        of "_intersect" do  
        of "discont" do
        of "Union" do
          break
        otherwise
          l:= map([op(S)], u-> solvelib::substituteBySet(a, x, u));
          if contains(l, FAIL) > 0 then
            return(FAIL)
          else  
            return(eval(op(S,0))(op(l)))
          end_if
      end_case;
      break
  end_case;

  if not has(a, x) then
    {a}
  else
    newidents:= genident();
    if domtype(a) = DOM_LIST or domtype(a) = matrix then
      solvelib::VectorImageSet( subs(a, x = newidents), newidents, S)
    else  
      Dom::ImageSet(subs(a, x = newidents), newidents, S)
    end_if
  end_if
end_proc:


/*
    solvelib::substituteByVectorSet(a, v, S)

    a - expression
    v = [v1, ..., vn] - list of variables
    S - n-dimensional set

    returns the set {a | v1=x1, .., vn=xn;  [x1, .., xn] \in S }
    of all objects that can be obtained from a and some [x1, .., xn] in S
    by substitution vi=xi

*/
solvelib::substituteByVectorSet:=
proc(a, v: DOM_LIST, S: Type::Set):
  Type::Union(Type::Set, DOM_FAIL)
  local substituteVector: DOM_PROC, s, l, i;
begin
  assert(nops(v) >= 1);  
  
  if a = matrix(v) then
    return(S)
  end_if;
  
  if S::dom::substituteBySet <> FAIL then
    return(S::dom::substituteBySet(args()))
  end_if;
  
  if nops(v) = 1 then
    s:= solvelib::vectorSetToNumberSet(S);
    if s = FAIL then
      userinfo(10, "Conversion of vector set to number set failed");
      return(FAIL)
    else  
      return(solvelib::substituteBySet(a, op(v, 1), s))
    end_if
  end_if;
  
  // substituteVector(a, x)
  // substitute v1=x1, v2=x2, ... in a
  // where v=[v1, ..., vn] and x=[x1, .., xn]
  substituteVector:=
  proc(x: matrix)
    local i;
  begin
    assert(nops(v) = nops(x));
    a | (v[i] = x[i] $i=1..nops(v))
  end_proc;
  
  case type(S)
    of "_union" do
      l:= map([op(S)], s -> solvelib::substituteByVectorSet(a, v, s));
      if contains(l, FAIL) > 0 then
        return(FAIL)
      else
        return(_union(op(l)))
      end_if
    of DOM_SET do
      return(map(S, substituteVector))
  end_case;
  
  // last chance:
  userinfo(10, "Trying to split set of type ".expr2text(S).
           " as a cartesian product");
  if (l:= solvelib::splitVectorSet(S, nops(v))) <> FAIL then
    a:= piecewise::extmap
    (l,
     proc(ll)
       local b;
     begin
       assert(nops(ll) = nops(v));
       b:= {a};
       for i from 1 to nops(ll) do
         b:= solvelib::Union(b, v[i], ll[i]);
         if b = FAIL then
           return(FAIL)
         end_if;
       end_for;
       b
     end_proc
     );
    if has(a, FAIL) then
      return(FAIL)
    else
      return(a)
    end_if
  end_if;
  
  // default
  FAIL
end_proc:

