
/*
solvelib::twoTerms(p, x, options)

p - polynomial having exactly two terms, with p(0) = 0
x - variable
options - table of options

returns the set of all solutions to p(x) = 0

*/ 

solvelib::twoTerms:=
proc(p: DOM_POLY, x, options: DOM_TABLE)
  local l: DOM_LIST, term2;
begin
  assert(nterms(p) = 2);
  assert(iszero(coeff(p, 0)));

  l:= poly2list(p);
  assert(nops(l) = 2);
  term2:= op(l, 2); // trailing term
  
  // the output of poly2list is sorted such that term2 has smaller degree than term1
  solvelib::solve_poly(divide(p, poly(x^term2[2]), Exact), x, options) union
  solvelib::solve_eq(x^term2[2], x, options)

end_proc:
// end of file


