Li:=
proc(x)
begin
  if args(0) = 0 then
    error("no arguments given")
  elif x::dom::Li <> FAIL then
    return(x::dom::Li(args()))
  elif args(0) <> 1 then
    error("wrong no of args")
  end_if;

  case type(x)
    of DOM_SET do
    of "_union" do
      return(map(x, Li))
    of DOM_FLOAT do
      return(Li::float(x))
    of DOM_COMPLEX do
      if domtype(op(x, 1)) = DOM_FLOAT or domtype(op(x, 2)) = DOM_FLOAT then
        return(Li::float(x))
      end_if
  end_case;

  if not testtype(x,Type::Arithmetical) then
    /* generic handling of sets */
    if testtype(x, Type::Set) then
      if type(x)=Dom::ImageSet then
        return(map(x, Li));
      else
        return(Dom::ImageSet(Li(#x), #x, x));
      end_if;
    end_if;

    error("argument must be of 'Type::Arithmetical'")
  end_if;

  procname(x)
end_proc:

Li := prog::remember(Li, 
  () -> [property::depends(args()), DIGITS, slotAssignCounter("Li")]):

Li(0):= 0:
Li(1):= -infinity:
Li(infinity):= infinity:
Li(-infinity):= -infinity + I*infinity:
Li(infinity*I):= infinity + I*infinity:
Li(-infinity*I):= infinity - I*infinity:
Li(RD_NAN):= RD_NAN:
Li(RD_INF):= RD_INF:
Li(RD_NINF):= RD_NINF + I*RD_INF:
Li(RD_INF*I):= RD_INF + I*RD_INF:
Li(RD_NINF*I):= RD_INF + I*RD_NINF:

Li:= funcenv(Li):

Li::type:= "Li":
Li::print:="Li":
Li::info:= "Li - the integral logarithm [try ?Li for details]":
 

Li::diff:=
proc(a, x)
  local z;
begin
  z:= op(a, 1);
  if args(0) = 1 then
    hold(Li)(z)
  elif not has(z, x) then
    0
  else
    diff(z, x)/ln(z)
  end_if
end_proc:


Li::series:= loadproc(Li::series, pathname("SERIES"), "Li"):

Li::conjugate:=
proc(z)
begin
  if is(z >= 0) = TRUE then 
     return(Li(z)); // Li(positive) = real
  end_if:
  if is(z < 0) = FALSE then
     return(hold(Li)(conjugate(z)));
  end_if;
  return(hold(conjugate)(hold(Li)(z)));
end_proc:

Li::rectform:=
proc(x)
begin
  if is(x>=0) = TRUE then
    new(rectform, Li(x), 0, 0)
  else
    new(rectform, 0, 0, Li(x))
  end_if;
end_proc:

Li::Re:=
proc(x)
begin
  if is(x>=0) = TRUE then
     return(hold(Li)(x)); // Li(x) is real
  end_if;
  hold(Re)(hold(Li)(x));
end_proc:

Li::Im:=
proc(x)
begin
  if is(x>=0) = TRUE then
     return(0); // Li(x) is real
  end_if;
  hold(Im)(hold(Li)(x));
end_proc:

Li::abs:=
proc(x)
local x0, x1;
begin
  if is(x>=0) = TRUE then
     // the following interval [x0, x1] contains the 110-DIGITS
     // numerical root of Li(x) = 0 on the positve half line.
     x0:= 1.4513692348833810502839684858920274494930322836480158630930045576624255957545178356595313577110868288470407515;
     x1:= 1.4513692348833810502839684858920274494930322836480158630930045576624255957545178356595313577110868288470407516;
     x0:= x0*(1 - 1/2*10^(-DIGITS));
     x1:= x1*(1 + 1/2*10^(-DIGITS));
     if is(x<= x0) = TRUE then
        return(-Li(x)); // Li(x) is real and negative
     end_if:
     if is(x>= x1) = TRUE then
        return(Li(x)); // Li(x) is real and positive
     end_if:
  end_if;
  hold(abs)(hold(Li)(x));
end_proc:

Li::complexDiscont:= Dom::Interval(-infinity, [1]):
Li::realDiscont:= {1}:
Li::undefined:= {1}:
  
//to do: Li::laplace

Li::float:=
proc(x)
begin
  x:= float(x);

  if iszero(x) then
    return(float(0))
  end_if;
    
  case type(x)
    of DOM_FLOAT do
    of DOM_COMPLEX do
        return(Ei::float(ln::float(x)));
  end_case;
  hold(Li)(x)
end_proc:
