// Prudnikov/Brychow, "Integrals and Series", Vol. 3, 2.24.2.2:
/*
 a
  /
 |   r - 1        s - 1        (
 |  x      (a - x)      meijerG([[a1, ..., am], [am1, ..., ap]],
/
 0

                                       l/k )
   [[b1, ..., bn], [bn1, ..., bq]], o x    ) dx =

         s + l r - 1  mu
        a            k   gamma(s)
   ---------------------------------- *
                    /         p   q \
            (k - 1) | m + n - - - - |
    s               \         2   2 /
   l  (2 PI)

                                            l  k (p - q)  k
   meijerG([[...], [...]], [[...], [...]], a  k          o )


where mu = _plus(b1, ..., bq) - _plus(a1, ..., ap) + (p-q)/2 + 1
*/


specfunc::MeijerG::convolutionInt::int_2_24_2_2 := proc( bound, alpha, beta, GList, var )
  local subst, G1, m1,
    a, b, m, n, p, q, cstar,
    mu, omega, l, k, r,
    cond,
    i, checkConditions,
    res, tmp;
begin
  checkConditions := proc()
    local i, j, i1, i2, allCond,
    conditions,
      val, subcond, subconds, subcondsval;
  begin
    subcondsval := table();
    subconds := [
      TRUE, /* 1 */
      proc() local j; 
      begin 
        for j from 1 to m do 
          if not is(Re(alpha+l/k*b[j])>0, Goal=TRUE) then 
             return(FALSE); 
          end_if; end_for; 
        return(TRUE); 
      end_proc, /* 2 */
      TRUE, /* 3 */
      TRUE, /* 4 */
      proc() local h; 
      begin 
         if is( (p-q)*Re(alpha)-r*Re(mu)>-3*r/2, Goal=TRUE )=FALSE then 
            return( FALSE ); 
         end_if; 
         return(TRUE); 
      end_proc, /* 5 */
      proc() local i; 
      begin 
        for i from 1 to n do 
          if is( -Re(1-beta)>-3/2, Goal=TRUE )=FALSE then 
             return( FALSE ); 
          end_if; 
        end_for; 
        return(TRUE); 
      end_proc, /* 6 */
      proc() 
       local j; 
      begin 
         for j from 1 to m do 
           if is( -Re(1-beta)>-3/2, Goal=TRUE )=FALSE then 
              return( FALSE ); 
           end_if; 
         end_for; 
         return(TRUE); 
      end_proc, /* 7 */
      ()->is( abs(q-p) + 2*Re( (q-p)*(p-1) )>0, Goal=TRUE ), /* 8 */
      ()->is( abs(q-p) - 2*Re( (q-p)*(p-1) )>0, Goal=TRUE ), /* 9 */
      FALSE, /* 10 */
      TRUE, /* 11 */
      ()->simplify::simplifyCondition( abs(arg(omega))<cstar*PI ), /* 12 */
      ()->simplify::simplifyCondition( abs(arg(omega))=cstar*PI ) /* 13 */
    ];
    subcond := proc(num)
    begin
      if not contains( subcondsval, num ) then
        if num>nops(subconds) then return( TRUE ); end_if;
        subcondsval[num] := subconds[num]();
      end_if;
      return( subcondsval[num] );
    end_proc;
    conditions := [
      [cstar>0, Re(1-beta)<1, [1,2,3,12] ],
      [p=q, 0=cstar, omega>0, Re(mu)<1, Re(1-beta)<1, 1/bound^l<>omega^k, [1,2,3] ],
      [p=q, 0=cstar, omega>0, Re(mu+1-beta)<1, 1/bound^l=omega^k, [1,2,3] ], /* 5) */
      [p>q, cstar>=0, Re(1-beta)<1, [1,2,3,5,13] ],
      [p<q, cstar>=0, Re(1-beta)<1, [1,2,3,4,13] ], /* 11) */
      [n=0, m>0, cstar>0, q-p<0, [1,2,12] ],
      [m=0, n>0, cstar>0, q-p>0, [1,3,12] ] /* 21) */
    ];

    allCond := FALSE;
    for i in conditions do
      val := TRUE;
      for j in i do
        if type(j)=DOM_LIST then
          for i1 in j do
            i2 := subcond(i1);
            if i2=FALSE then val := FALSE; break; end_if;
            val := val and i2;
          end_for;
        else
          i2 := simplify::simplifyCondition(j);
          if i2=FALSE then val := FALSE; break; end_if;
          val := val and i2;
        end_if;
      end_for;
      if val=TRUE then return(TRUE); end_if;
      if val<>FALSE then allCond := allCond or val; end_if;
    end_for;
    return( allCond );
  end_proc;

  assert( nops(GList)=1 ); /* Verantwortung des Aufrufers */
  cond := simplify::simplifyCondition( not -beta+1 in N_ );
  if cond=FALSE then return( FAIL ); end_if;

  G1 := op(GList,1);
  [m1,G1] := specfunc::MeijerG::convolutionInt::extractFactor( G1, var );
  if G1=FAIL then return(FAIL); end_if;
  subst := specfunc::MeijerG::convolutionInt::analyzeSubst( G1, var );
  if subst=FAIL then return( FAIL ); end_if;

  [ omega, tmp, l, k ] := subst;
  cond := cond and omega<>0;
  if tmp<>0 or l<=0 or k<=0 then return( FAIL ); end_if;
  mu := specfunc::MeijerG::convolutionInt::mymu( G1 );
  m := nops(op(G1,[2,1]));
  n := nops(op(G1,[1,1]));
  p := nops(op(G1,[1,1])) + nops(op(G1,[1,2]));
  q := nops(op(G1,[2,1])) + nops(op(G1,[2,2]));
  a := op(G1,[1,1]).op(G1,[1,2]);
  b := op(G1,[2,1]).op(G1,[2,2]);
  r := l/k;

  cstar := m+n-(p+q)/2;
  cond := cond and checkConditions();
  if cond=FALSE then return( FAIL ); end_if;

  res := k^mu*l^(-beta)*gamma(beta)/(2*PI)^(cstar*(k-1))/bound^(1-alpha-beta) *
      meijerG([[specfunc::MeijerG::convolutionInt::delta( l, 1-alpha ), 
                specfunc::MeijerG::convolutionInt::delta( k, a[i] ) $ i=1..n ], 
               [specfunc::MeijerG::convolutionInt::delta( k, a[i] ) $ i=(n+1)..p ]], 
              [[specfunc::MeijerG::convolutionInt::delta( k, b[i] ) $ i=1..m],
               [specfunc::MeijerG::convolutionInt::delta( k, b[i] ) $ i=(m+1)..q,
                specfunc::MeijerG::convolutionInt::delta( l, 1-alpha-beta )]], 
              omega^k*bound^l/k^(k*(q-p)) );

  res := Simplify(m1*res);
  if cond<>TRUE then res := piecewise( [cond,res] ); end_if;
  return( res );
end_proc:
