patterns := read( "toMeijerGPatterns.mu" ):

/* DGLLookup-Tabellen */
proc()
  local i, G, subst, m, n, p, q, a, b, params;
  save patterns;
begin
DGLLookup := table():
for i in patterns do
  G := i[2];
  [m,G] := specfunc::MeijerG::convolutionInt::extractFactor( G, #x );
  if G=FAIL or type(G)<>"meijerG" then next; end_if;
  params := {op(op(G,[1,1]))} union {op(op(G,[1,2]))} union {op(op(G,[2,1]))} union {op(op(G,[2,2]))};
  params := map(params, testtype, Type::Arithmetical);
  if params<>{TRUE} then
    next;
  end_if;
  subst := op(G,3)/#x;
  if has( subst, #x ) then next; end_if;
  G := subsop( G, 3=#x );
  res := i[1]/m;
  res := subs( res, #x=#x/subst );
  if freeIndets( res ) minus indets( G )<>{} then next; end_if;
  m := nops(op(G,[2,1]));
  n := nops(op(G,[1,1]));
  p := nops(op(G,[1,1])) + nops(op(G,[1,2]));
  q := nops(op(G,[2,1])) + nops(op(G,[2,2]));
  a := op(G,[1,1]).op(G,[1,2]);
  b := op(G,[2,1]).op(G,[2,2]);
  if not contains( DGLLookup, [m,n,p,q] ) then
    DGLLookup[ [m,n,p,q] ] := [];
  end_if;
  DGLLookup[ [m,n,p,q] ] := DGLLookup[ [m,n,p,q] ].[ [a, b, fp::unapply(res,#x)] ];
end_for:
patterns := DGLLookup:
write( "DGLLookup.mb", patterns ):
end_proc():

// quit:
// patterns := read( "toMeijerGPatterns.mu" ):
patterns := map( subs( patterns, #x=#x^#SC*#SA-#SB, Unsimplified ),
  l -> subsop(l, 3=l[3].[matchlib::block(not iszero(#SA)), matchlib::block(not iszero(#SC))])):
LEVEL := 1: // spart Zeit beim Einlesen
patterns := matchlib::einwohner::compile( patterns,
  #x, {} ):
write( "toMeijerGPatterns.mb", patterns ):
null():
quit:
