/* reduceAdamchik1996( meijerG-Fnct )
 * Tries to reduce the meijerG-Function to an equivalent one of lower order.
 * Uses the algorithm described in "The evaluation of integrals of Bessel functions via G-function identities" (Victor Adamchik, 1996)
 */
specfunc::MeijerG::reduceAdamchik1996 := proc( G )
  local m, n, p, q, a, b, z, a1, a2, b1, b2,
    i, j, k, l, w,
    valid, res, residual;
begin
  if type(G)<>"meijerG" then return( G ); end_if;
  m := nops(op(G,[2,1]));
  n := nops(op(G,[1,1]));
  p := nops(op(G,[1,1])) + nops(op(G,[1,2]));
  q := nops(op(G,[2,1])) + nops(op(G,[2,2]));

  [ a1,a2 ] := op(G,[1]);
  [ b1,b2 ] := op(G,[2]);
  z := op(G,3);

  residual := proc( a, b, prodto, sfrom, kfactor, a1, a2, b1, b2, z )
    local k, v, s, l,
      fact, res, result,
      denomgamma, nomgamma;
  begin
    result := 0;
    for k from 1 to prodto do
      res := 0;
      s := sfrom + kfactor*k;
      fact := z^(-s);
      denomgamma := [ b+s ];
      for l from 1 to nops(b1) do denomgamma := denomgamma.[b1[l]+s]; end_for;
      for l from 1 to nops(a1) do denomgamma := denomgamma.[1-a1[l]-s]; end_for;
      nomgamma := [];
      for l from 1 to nops(b2) do nomgamma := nomgamma.[1-b2[l]-s]; end_for;
      for l from 1 to nops(a2) do nomgamma := nomgamma.[a2[l]+s]; end_for;
      for v in denomgamma do
        case is(v<=0 and v in Z_)
          of FALSE do
            fact := fact*gamma(v);
            break;
          of TRUE do
            if res<>0 then return(FAIL);end_if;
            res := (-1)^(-v)/(-v)!;
            break;
          of UNKNOWN do
            return(FAIL);
        end_case;
      end_for;

      for v in nomgamma do
        case is(v<=0 and v in Z_)
          of FALSE do
            fact := fact/gamma(v);
            break;
          of TRUE do
            if res<>0 then return(FAIL);end_if;
            res := (-1)^(-v)*(-v)!;
            break;
          of UNKNOWN do
            return(FAIL);
        end_case;
      end_for;
      result := result + fact*res;
    end_for;
    (-1)^(a-b)*result;
  end_proc;

  /* Proposition 1 */
  if p>=1 and q>1 then
    for i from 1 to n do
      if ( l := contains( b1, a1[i] ) )>0 then
        a := a1[i];
        /* Wir haben a_i = b_l und versuchen diese aufzuheben. Als nchstes suchen wir
        * ein b_j, j=m+1..q mit a_i-b in Z_ */
        for j from 1 to nops(b2) do
          if is( a-b2[j], Type::Integer, Goal=TRUE ) then
            /* Jetzt muss nur noch a_k-b not in Z_+, k=1..n, k<>i gelten. */
            b := b2[j];
            valid := TRUE;
            for k from 1 to n do
              if k=i then next; end_if;
              if is( a1[k]-b, Type::PosInt, Goal=FALSE ) then
                valid := FALSE;
                break;
              end_if;
            end_for;
            if valid then
              /* Es sind alle Bedingungen fr die Transformation in Prop.1 erfllt */
              case is(a-b>0)
                of TRUE do
                  res := ( residual( a, b, a-b, -a, 1, [a1[w] $ w=1..(i-1), a1[w] $ w=(i+1)..(n)], a2,
                    [b1[w] $ w=1..(l-1), b1[w] $ w=(l+1)..(m)], [b2[w] $ w=1..(j-1), b2[w] $ w=(j+1)..(q-m)], z ) );
                  if res<>FAIL then
                    G := (-1)^(a-b)*meijerG::Simplify( meijerG( [[a1[w] $ w=1..(i-1), a1[w] $ w=(i+1)..(n)], a2],
                      [[b, b1[w] $ w=1..(l-1), b1[w] $ w=(l+1)..(m)], [b2[w] $ w=1..(j-1), b2[w] $ w=(j+1)..(q-m)]], z ) )
                      - res;
                    return( G );
                  end_if;
                  break;
                of FALSE do
                  G := (-1)^(a-b)*meijerG::Simplify( meijerG( [[a1[w] $ w=1..(i-1), a1[w] $ w=(i+1)..(n)], a2],
                      [[b, b1[w] $ w=1..(l-1), b1[w] $ w=(l+1)..(m)], [b2[w] $ w=1..(j-1), b2[w] $ w=(j+1)..(q-m)]], z ) );
                  return( G );
              end_case;
            end_if;
          end_if;
        end_for;
      end_if;
    end_for;
  end_if;

  /* Proposition 2 */
  if n>=1 and p>=2 and q>=1 and m<q and n<q then
    for i from 1 to p-n do
      if ( l := contains( b2, a2[i] ) )>0 then
        b := a2[i];
        /* wir haben ein b mit a2_i=b2_l(=b). Wir suchen nun ein a mit a-b in Z_ */
        for j from 1 to n do
          if is( b-a1[j], Type::Integer, Goal=TRUE ) then
            a := a1[j];
            delete a2[i];
            delete b2[i];
            delete a1[j];
            a2 := a2.[ a ];
            return( meijerG::Simplify( meijerG( [a1,a2],[b1,b2], z ) ) );
          end_if;
        end_for;
      end;
    end_for;
  end_if;
  G;
end_proc:

