/*  */

/* Skipped:
 * 8.4.8 The inverse hyperbolic functions
 * 8.4.9 The polylogarithm
 * 8.4.10 The function Phi(x,s,v)
 * 8.4.12 The integral sines... [alles mit si/ci]
 * 8.4.13 The integral hyperbolic sine shi(x) and cosine chi(x)
 * 8.4.15 The Fresnel integrals S(x) and C(x)
 */

proc()
  save patterns;
begin
  patterns := read( "SPECFUNC".stdlib::PathSep."MEIJERG".stdlib::PathSep."DGLLookup.mb" ):
  specfunc::MeijerG::DGLLookup := patterns:
end():

specfunc::MeijerG::reduceDGL := proc( G )
  local m, n, p, q, a, b, i, j, inds, v, targets, x,
    use, walk, target, z, res, diffs, sigma, bdiff,
    inputIndets, target1, target2, tries, matchList;
begin
  z := genident();
  walk := proc( a, b )
    local k, j, myD, zDz, ops, py, fc, fcs,
      shiftOperators;
  begin
    if a=op(target,1) and b=op(target,2) then
      if type( op(target,3) )=DOM_LIST then
        k := specfunc::MeijerG::reduceDGL( op(op(target,3)) );
        if not hastype( k, "meijerG" ) then return( k ); end_if;
        return( FAIL );
      end_if;
      return( op(target,3)(z) );
    end_if;


    shiftOperators := proc()
      local i, As, Bs;
    begin
      As := Bs := [];
      for i from 1 to n do
        As := As.[ 1 - a[i] + zDz ];
      end_for;
      for i from n+1 to p do
        As := As.[ a[i] - 1 - zDz ];
      end_for;
      for i from 1 to m do
        Bs := Bs.[ b[i] - zDz ];
      end_for;
      for i from m+1 to q do
        Bs := Bs.[ - b[i] + zDz ];
      end_for;
      [ As, Bs ];
    end_proc;

    for j from 1 to n do
      if a[j]-op(target,[1,j])<0 then
        if traperror((
             fc := walk( subsop(a, j=a[j]+1), b ):
           )) <> 0 then
           next;
        end_if;
        if fc=FAIL then return(FAIL); end_if;
        fc := (-a[j])*fc+z*diff( fc, z );
        fc := normal(fc);
        return( fc );
      elif a[j]-op(target,[1,j])>0 then
        /* wir mssen rckwrts laufen, wir suchen den inversen Operator */
        myD := genident();
        zDz := -1+a[j]+myD;
        ops := shiftOperators( zDz );
        py := z*_mult(op(ops[1])) - _mult(op(ops[2]));
        py := poly(py,[myD]);
        if coeff(py,0)=0 then return( FAIL ); end_if;
        if traperror((
             fc := walk( subsop(a,j=a[j]-1), b );
           )) <> 0 then
           return(FAIL);
        end_if:
        if fc=FAIL then return(FAIL); end_if;
        fcs := 0;
        for k from 1 to degree(py) do
          if k>1 then fc := (1-a[j])*fc + z*diff( fc, z ); end_if;
          fcs := fcs + coeff(py,k)*fc;
        end_for;
        fcs := normal(fcs);
        return( -fcs/coeff(py,0) );
      end_if;
    end_for;
    for j from n+1 to p do
      if a[j]-op(target,[1,j])<0 then
        if traperror((
           fc := walk( subsop(a, j=a[j]+1), b );
           )) <> 0 then
           next;
        end_if;
        if fc=FAIL then return(FAIL); end_if;
        fc := a[j]*fc-z*diff( fc, z );
        fc := normal(fc);
        return( fc );
      elif a[j]-op(target,[1,j])>0 then
        /* wir mssen rckwrts laufen, wir suchen den inversen Operator */
        myD := genident();
        zDz := a[j]-1-myD;
        ops := shiftOperators( zDz );
        py := z*_mult(op(ops[1])) - _mult(op(ops[2]));
        py := poly(py,[myD]);
        if coeff(py,0)=0 then return( FAIL ); end_if;
        if traperror((
           fc := walk( subsop(a,j=a[j]-1), b );
           )) <> 0 then
           return(FAIL);
        end_if:
        if fc=FAIL then return(FAIL); end_if;
        fcs := 0;
        for k from 1 to degree(py) do
          if k>1 then fc := (a[j]-1)*fc - z*diff( fc, z ); end_if;
          fcs := fcs + coeff(py,k)*fc;
        end_for;
        fcs := normal(fcs);
        return( -fcs/coeff(py,0) );
      end_if;
    end_for;
    for j from 1 to m do
      if b[j]-op(target,[2,j])>0 then
        if traperror((
           fc := walk( a, subsop(b, j=b[j]-1) );
           )) <> 0 then
           return(FAIL);
        end_if:
        if fc=FAIL then return(FAIL); end_if;
        fc := (b[j]-1)*fc-z*diff( fc, z );
        fc := normal(fc);
        return( fc );
      elif b[j]-op(target,[2,j])<0 then
        /* wir mssen rckwrts laufen, wir suchen den inversen Operator */
        myD := genident();
        zDz := b[j]-myD;
        ops := shiftOperators( zDz );
        ops[2][j] := myD;
        py := z*_mult(op(ops[1])) - _mult(op(ops[2]));
        py := poly(py,[myD]);
        if coeff(py,0)=0 then return( FAIL ); end_if;
        if traperror((
           fc := walk( a, subsop(b, j=b[j]+1) );
           )) <> 0 then
           next;
        end_if;
        if fc=FAIL then return(FAIL); end_if;
        fcs := 0;
        for k from 1 to degree(py) do
          if k>1 then fc := (b[j])*fc - z*diff( fc, z ); end_if;
          fcs := fcs + coeff(py,k)*fc;
        end_for;
        fcs := normal(fcs);
        return( -fcs/coeff(py,0) );
      end_if;
    end_for;
    for j from m+1 to q do
      if b[j]-op(target,[2,j])>0 then
        if traperror((
           fc := walk( a, subsop(b, j=b[j]-1) );
           )) <> 0 then
           return(FAIL);
        end_if:
        if fc=FAIL then return(FAIL); end_if;
        fc := (1-b[j])*fc+z*diff( fc, z );
        fc := normal(fc);
        return( fc );
      elif b[j]-op(target,[2,j])<0 then
        /* wir mssen rckwrts laufen, wir suchen den inversen Operator */
        myD := genident();
        zDz := myD+b[j];
        ops := shiftOperators( zDz );
        py := z*_mult(op(ops[1])) - _mult(op(ops[2]));
        py := poly(py,[myD]);
        if coeff(py,0)=0 then return( FAIL ); end_if;
        if traperror((
           fc := walk( a, subsop(b, j=b[j]+1) );
           )) <> 0 then
           next;
        end_if:
        if fc=FAIL then return(FAIL); end_if;
        fcs := 0;
        for k from 1 to degree(py) do
          if k>1 then fc := (-b[j])*fc + z*diff( fc, z ); end_if;
          fcs := fcs + coeff(py,k)*fc;
        end_for;
        fcs := normal(fcs);
        return( -fcs/coeff(py,0) );
      end_if;
    end_for;
    return( FAIL );
  end_proc:

  m := nops(op(G,[2,1]));
  n := nops(op(G,[1,1]));
  p := nops(op(G,[1,1])) + nops(op(G,[1,2]));
  q := nops(op(G,[2,1])) + nops(op(G,[2,2]));
  a := op(G,[1,1]).op(G,[1,2]);
  b := op(G,[2,1]).op(G,[2,2]);
  inputIndets := freeIndets([a, b]);
  if contains( specfunc::MeijerG::DGLLookup, [m,n,p,q] ) then
    targets := specfunc::MeijerG::DGLLookup[ [m,n,p,q] ];
  else
    targets := [];
  end_if;
  if contains( specfunc::MeijerG::DGLLookup, [n,m,q,p] ) then
    for i in specfunc::MeijerG::DGLLookup[ [n,m,q,p] ] do
      x := genident();
      j := i[3](1/x);
      targets := targets.[ [map(i[2],X->1-X), map(i[1],X->1-X), fp::unapply( j, x )] ];
    end_for;
  end_if;
  for target in targets do
    diffs["A"] := [];
    diffs["B"] := [];
    use := TRUE;
    if p>0 then
      if freeIndets(op(target,[1,1]))={} then
        bdiff := op(target,[1,1])-a[1] - floor(op(target,[1,1])-a[1]);
      else
        bdiff := 0;
      end_if;
    elif q>0 then
      if freeIndets(op(target,[2,1]))={} then
        bdiff := op(target,[2,1])-b[1] - floor(op(target,[2,1])-b[1]);
      else
        bdiff := 0;
      end_if;
    else
      bdiff := 0;
    end_if;

/*
matchList(a, a1)

   a = parameter list of meijerG on input
  a1 = parameter list of potential meijerG for which 
       an explicit representation is known
 typ = "A" or "B", indicates, whether the lists a, a1
       are A or B in the call 
       meijerG([A[1], A[2]], [B[1], B[2]], x)

Return value: 
   - FAIL, if there is no element of a that differs
     from any element in a1 by an integer
   - a list with elements that differ from 
     the elements in a by integers and that is generated 
     from a1 by
       - sorting
       - substitution of symbolic idents by suitable values
*/
    matchList := proc( a, a1, typ )
      local targeta, j, k, l, num;
    begin
      targeta := [];
      for j from 1 to nops(a) do
        l := 1;
        for k from 1 to nops(a1) do
          if type(a1[k]-bdiff-a[j])=DOM_INT then
            if type(a1[l]-bdiff-a[j])<>DOM_INT or 
               type(a1[l]-bdiff-a[j])=DOM_INT and 
                abs(a1[k]-bdiff-a[j])<abs(a1[l]-bdiff-a[j]) then
              l := k;
            end_if;
          end_if;
        end_for;
        num := a1[l];
        a1[l] := null();

        inds := freeIndets( num ) minus inputIndets;;
        if inds<>{} then
          if nops(inds)>1 then return(FAIL); end_if;
          v := solve( num-a[j]-bdiff=0, op(inds) );
          if type(v)<>DOM_SET or nops(v)<>1 then return(FAIL); end_if;
          target := subs( target, op(inds)=op(v) );
          a1 := subs( a1, op(inds)=op(v) );
          num := a[j]+bdiff;
        end_if;
        if type( num-a[j]-bdiff )<>DOM_INT then
          return(FAIL); 
        end_if;
        diffs[typ] := diffs[typ].[ num-a[j]-bdiff ];
        targeta := targeta.[ num ];
      end_for;
      targeta;
    end_proc:

    use := FALSE;
    if ( target1 := matchList( [op(a,1..n)], [op( target, [1,1..n] )], "A" ) )<>FAIL then
      if ( target2 := matchList( [op(a,(n+1)..p)], [op( target, [1,(n+1)..p] )], "A" ) )<>FAIL then
        target[1] := target1.target2;
        if ( target1 := matchList( [op(b,1..m)], [op( target, [2,1..m] )], "B" ) )<>FAIL then
          if ( target2 := matchList( [op(b,(m+1)..q)], [op( target, [2,(m+1)..q] )], "B" ) )<>FAIL then
            target[2] := target1.target2;
            use := TRUE;
          end_if;
        end_if;
      end_if;
    end_if;

    if not use then next; end_if;

//  sigma := round(_plus(op(diffs))/nops(diffs))+bdiff;
    // Optimize [minB .. maxB] ... [minA .. maxA]
    if nops(diffs["A"]) = 0 then
       sigma:= max(diffs["B"]);
    elif nops(diffs["B"]) = 0 then
       sigma:= min(diffs["A"]);
    else
       sigma:= round( ( min(diffs["A"]) + max(diffs["B"]) )/2 );
    end_if:
    sigma:= sigma + bdiff;
       
    userinfo( 10, "Potential target for rewriting: ".target );
    res := walk( map(a, _plus, sigma), map(b, _plus, sigma) );
    if res<>FAIL then
      G := evalAt( res, z=op(G,3) )*op(G,3)^(-sigma);
      return( G );
    end_if;
  end_for;

  tries := [];
  for i from 1 to n do
    for j from m+1 to q do
      if type( a[i]-b[j] )=DOM_INT then
        res := meijerG( eval(subsop( op(G,1), [1,i]=null() )), 
                        eval(subsop( op(G,2), [2,j-m]=null() )), z );
        target := [ subsop(a, i=b[j]), b, [res] ];
        tries := tries.[ [i, j, a[i]-b[j], target] ];
      end_if;
    end_for;
  end_for;

  for j from 1 to m do
    for i from n+1 to p do
      if type( a[i]-b[j] )=DOM_INT then
        res := meijerG( eval(subsop( op(G,1), [2,i-n]=null() )), 
                        eval(subsop( op(G,2), [1,j]=null() )), z );
        target := [ subsop(a, i=b[j]), b, [res] ];
        tries := tries.[ [i, j, a[i]-b[j], target] ];
      end_if;
    end_for;
  end_for;

  tries := sort( tries, proc(x,y) begin
    if x[3]<0 then
      if y[3]>0 then return( FALSE ); end_if;
      return( x[3]<y[3] );
    else
      if y[3]<0 then return( TRUE ); end_if;
      return( x[3]<y[3] );
    end_if; end_proc );

  for i in tries do
    target := i[4];
    res := walk( a, b );
          if res<>FAIL then
            G := subs( res, z=op(G,3) );
            return( G );
          end_if;
  end_for;

  G;
end_proc:
