
/*--
	log/sign -- the function attribut "sign" for log
--*/

log::sign:=
  proc(x)
    local b, s, ss, t;
  begin
    // x = log(b, y) = ln(y)/ln(b)
    s := sign(op(x,2)); 
    b := op(x,1); 
    if s = 1 then  // y=op(x,2) is real and positive
        if is(b>=1)=TRUE then
           return( sign( op(x,2)-1 ) )
        end_if;
	if /* is(b>=0) = TRUE and */
           // the above is an *implicit* assumption
           is(b<=1) = TRUE then
	   // 0 < b < 1
           return(-sign( op(x,2)-1 ) )
	end_if;
        return( hold(sign)(x) )
    end_if;
    s:= Re(x);
    if not has(s,{Re,Im,sign, log}) then
        ss := Im(x);
        if not has(ss,{Re, Im, sign, log}) then
             t := sqrt( s^2*sign(s)^2+ss^2*sign(ss)^2 );
             if not iszero(t) then 
                return( (s+I*ss)/t )
             end_if
        end_if;
    end_if;
    hold(sign)(x)
  end_proc:

// end of file 
