/*++
	abs -- returns the absolute value of an expression

	abs(x)

	x - expression
++*/

abs := funcenv
(prog::remember(
 proc(x)
   name abs;
   option noDebug;
   local t, aa, a, f;
 begin
   if args(0) = 0 then
     error("no arguments given")
   elif x::dom::abs <> FAIL then
     return(x::dom::abs(args()))
   elif args(0) <> 1 then
     error("wrong no of args")
   end_if;

 case type(x)
   of DOM_POLY do
      return(mapcoeffs(x, abs));
   of DOM_LIST do
   of DOM_ARRAY do
   of DOM_SET do
   of DOM_TABLE do
      return(map(x, abs));
   of DOM_HFARRAY do
      return(hfa::abs(x));
   of DOM_SET do
   of "_union" do
     return(map(x, abs))
   of DOM_INT     do
   of DOM_RAT     do
   of DOM_FLOAT   do
   of DOM_COMPLEX do
     return(specfunc::abs(x))
   of DOM_IDENT do
     // PI, EULER, CATALAN are handled by assignment below
     if property::hasprop(x) then
       if is(x>=0) = TRUE then
         return(x)
       elif is(x<=0) = TRUE then
         return(-x)
       end_if
     end_if;
     return(procname(x));
     // NOT REACHED
     assert(FALSE)
 end_case;

 if not testtype(x,Type::Arithmetical) then
  /* generic handling of sets */
  if testtype(x, Type::Set) then
    if type(x)=Dom::ImageSet then
      return(map(x, abs));
    else
      t := genident();
      return(Dom::ImageSet(abs(t), t, x));
    end_if;
  end_if;

   error("argument must be of 'Type::Arithmetical'")
 end_if;

 case domtype(x)
   of DOM_EXPR do
     t := eval(op(x,0));
     if domtype(t) = DOM_FUNC_ENV then
       if t::abs <> FAIL then
         return(t::abs(op(x)))
       end_if
     end_if;

     t := op(x, 0);
     case t
       of hold(_mult) do
         aa := 1;
         a := 1;
         for f in x do
           t := abs(f);
           if type(t)="abs" and op(t)=f then
             aa := aa*f
           else
             a := a*t
           end_if
         end_for;
         if aa <> x then
           if aa <> 1 then
             return(a*procname(aa))
           else
             return(a)
           end_if
         end_if;
         break
       of hold(_power) do
         if testtype(op(x,2),Type::Real) then
           // abs(x^y) ---> abs(x)^y.
           // However, note that we want
           // abs(Re(x)^2) --> Re(x)^2.
           // After rewriting to abs(Re(x))^2,
           // abs would not be able to do the
           // simplification --> we need to
           // call properties before rewriting:
           if property::hasprop(x) then
              if is(x>=0) = TRUE then
                return(x)
              elif is(x<=0) = TRUE then
                return(-x)
              end_if
           end_if;
           // do the rewriting abs(a^b) --> abs(a)^b
           // for b of type Type::Real
           return(abs(op(x,1))^op(x,2))
         end_if;
         break
       of hold(abs) do
         return(x)
     end_case
 end_case;

 if property::hasprop(x) then
    // try is
    if is(x >= 0) = TRUE then
      return(x);
    elif is(x <= 0) = TRUE then
      return(-x);
    end_if;
 end_if;

 if testtype(x, Type::Constant) then
   if not hastype((a:= Re(x)), {"Re", "Im"}) then
     if not hastype((aa:= Im(x)), {"Re", "Im"}) then
       return(sqrt(a^2 + aa^2))
     end_if
   end_if
 end_if;

 // try whether sign can handle the problem

 t:= sign(x);
 case t
 of 0 do
 of 1 do
    return(x);
 of -1 do
    return(-x);
 end_case;

 x:= op(stdlib::normalizesign(x), 2);
 return(procname(x));
end_proc, 
() -> [property::depends(args()), slotAssignCounter("abs"), DIGITS]),
proc(ex)
  local str;
begin
  if PRETTYPRINT then
    str := strprint(All, op(ex));
    if str[1] <> "" and str[2] = str[4] then // no line break
      if str[1][1] = "\n" then
        str[1] := str[1][2..-1];
        str[6] := str[6]-1;
      elif str[1][1..2] = "\r\n" then
        str[1] := str[1][3..-1];
        str[6] := str[6]-1;
      end_if;
      output::fence("|", "|", str[1], str[3], str[6])
    else FAIL end_if;
  else FAIL end_if;
end_proc,
table( "type"="abs", "print"="abs",
       "info"="abs(x) -- absolute value of x" )
):

abs(I):= 1:
abs(PI):=PI:
abs(EULER):=EULER:
abs(CATALAN):= CATALAN:
abs::diff:= proc(x) local i; begin
             sign(op(x,1)) * diff(op(x,1), args(i) $ i=2..args(0))
           end_proc:
abs::sign:= proc(X) begin
             case sign(op(X))
               of 0 do
                 return(0)
               of -1 do
               of 1 do
                 return(1)
               otherwise
                 return(hold(sign)(X))
             end_case
            end_proc:
abs::rectform:= loadproc(abs::rectform, pathname("STDLIB","RECTFORM"),"abs"):
abs::Re := hold(abs):
abs::Im := 0:
abs::series:= loadproc(abs::series,pathname("SERIES"),"abs"):
abs::expand:=
proc(a: "abs")
  local x;
begin
  x:= op(a, 1);
  if type(x)="_mult" then
    map(x, abs@expand)
  else
    abs(expand(x))
  end_if
end_proc:
abs::float := specfunc::abs@float:
abs::hull := DOM_INTERVAL::abs@hull:
abs::realDiscont:= {}:
abs::undefined:= {}:
abs::minprop := hold(Type::NonNegative): // minimal property
abs::conjugate:= loadproc(abs::conjugate,pathname("STDLIB","CONJ"),"abs"):
abs::simplify:= loadproc(abs::simplify,pathname("STDLIB","SIMPLIFY"),"abs"):

abs::"transform::laplace":=
    loadproc(abs::"transform::laplace",
        pathname("TRANS","LAPLACE"), "L_abs"):

// typesetting and MathML generation
abs::Content := stdlib::genOutFunc("Cabs", 1):

abs::getprop := proc( x, options ) begin return( Dom::Interval( [0], infinity ) ); end_proc:

// end of file
