// arccsc(x) = arcsin(1/x) 
arccsc := 
proc(x)
  option noDebug;
begin
  if args(0) = 0 then error("no arguments given")
  elif x::dom::arccsc <> FAIL then return(x::dom::arccsc(args()))
  elif args(0) <> 1 then error("1 argument expected")
  end_if;

  // handle sets
  case type(x)
    of DOM_SET do
    of "_union" do
      return(map(x, arccsc))
  end_case;
  if not testtype(x,Type::Arithmetical) then
    /* generic handling of sets */
    if testtype(x, Type::Set) then
      return(Dom::ImageSet(arccsc(#t), #t, x));
    end_if;
    error("argument must be of 'Type::Arithmetical'")
  elif iszero(x) then
    error("singularity")
  else
    arcsin(1/x)
  end_if
end_proc:

arccsc:= funcenv(arccsc):
arccsc::type := "arccsc":
arccsc::print := "arccsc":
arccsc::info := "arccsc -- the inverse cosecant":

arccsc::inverse := "csc":

arccsc::hull := DOM_INTERVAL::arccsc@hull:

arccsc::Content := stdlib::genOutFunc("Carccsc", 1):

// end of file 
