// arccsch(x) = arcsinh(1/x) 

arccsch :=
proc(x)
  option noDebug;
begin
  if args(0) = 0 then error("no arguments given")
  elif x::dom::arccsch <> FAIL then return(x::dom::arccsch(args()))
  elif args(0) <> 1 then error("1 argument expected")
  end_if;

  // handle sets
  case type(x)
    of DOM_SET do
    of "_union" do
      return(map(x, arccsch))
  end_case;

  if not testtype(x,Type::Arithmetical) then
    /* generic handling of sets */
    if testtype(x, Type::Set) then
      return(Dom::ImageSet(arccsch(#t), #t, x));
    end_if;
      error("argument must be of 'Type::Arithmetical'")
  elif iszero(x) then
      error("singularity")
  else
      arcsinh(1/x)
  end_if
end_proc:

arccsch:= funcenv(arccsch):
arccsch::print := "arccsch":
arccsch::info := "arccsch -- the inverse hyperbolic cosecant":
arccsch::type := "arccsch":

arccsch::inverse := "csch":

arccsch::hull := DOM_INTERVAL::arccsch@hull:

arccsch::Content := stdlib::genOutFunc("Carccsch", 1):

// end of file 
