binomial :=
proc(n: Type::Union(Type::Arithmetical, Type::Set), k: Type::Union(Type::Arithmetical, Type::Set))
  local i, nk1;
  name binomial;
begin
  if args(0) <> 2 then
    error("2 arguments expected")
  end_if;

  if domtype(k) = DOM_INTERVAL then 
     if domtype(n) <> DOM_INTERVAL then 
        n:= hull(n): 
     end_if:
     return(gamma(n+hull(1))/gamma(k+hull(1))/gamma(n-k+hull(1)) );
  end_if;
  if domtype(n) = DOM_INTERVAL then 
     if domtype(k) <> DOM_INTERVAL then 
        k:= hull(k): 
     end_if:
     return(gamma(n+hull(1))/gamma(k+hull(1))/gamma(n-k+hull(1)) );
  end_if;

  if domtype(n) = DOM_FLOAT or
    (domtype(n) = DOM_COMPLEX and
     domtype(op(n, 1)) = DOM_FLOAT) then
      return(binomial::float(n, k));
  end_if:
  if domtype(k) = DOM_FLOAT or
    (domtype(k) = DOM_COMPLEX and
     domtype(op(k, 1)) = DOM_FLOAT) then
      return(binomial::float(n, k));
  end_if:

  if iszero(k) or iszero(k - n) then 
    return(1)
  elif k = 1 or k = n - 1 then
    return(n)
  end_if;

  if domtype(n) = DOM_INT and n < 0 then
     if domtype(k) <> DOM_INT and
        (not iszero(frac(k))) and
        contains({DOM_FLOAT, DOM_COMPLEX}, domtype(float(k)))
        then
        // k is not an integer or a float of an integer
        error("singularity");
     end_if:
  end_if:

  // if k is not an integer, but n - k is an integer, then
  // binomial(n, k) can be expressed explicitly. In particular,
  // if n - k is a negative integer, then the result is 0:
  if domtype(k) <> DOM_INT and
    (domtype(float(k)) <> DOM_FLOAT or not iszero(frac(k))) then
     if (domtype(n-k) = DOM_INT or
        (domtype(float(n-k)) = DOM_FLOAT and iszero(frac(n-k)))) then
        if float(n - k) < 0 then
           return(0);
        elif testtype(n, Type::Numeric) then
           nk1:= round(n-k);
           return(_mult(n-k $ k = 0 .. nk1 -1)/nk1!):
        end_if;
     end_if:
  end_if:

  if not testtype(n, Type::Numeric) then
    if testtype(n, Type::Set) and not testtype(n, Type::Arithmetical) then
      if testtype(k, Type::Set) and not testtype(k, Type::Arithmetical) then
        return(Dom::ImageSet(binomial(#n, #k), [#n, #k], [n, k]));
      else
        return(Dom::ImageSet(binomial(#n, k), [#n], [n]));
      end_if;
    end_if;
    return(procname(n, k))
  elif not testtype(k, Type::Numeric) then
    if testtype(k, Type::Set) and not testtype(k, Type::Arithmetical) then
      return(Dom::ImageSet(binomial(n, #k), [#k], [k]));
    end_if;
    return(procname(n, k))
  end_if;

  case domtype(k)
  of DOM_INT do
     case domtype(n)
     of DOM_INT do
        if k < 0 then
           if 0 <= n then 
              return( 0 )
           elif n-k < 0 then
             // n<0 and k<0, and n < k
              return(0)
           else 
              return(binomial(n, n-k))
           end_if
        else // k > 0 
           if n < 0 then
              return((-1)^k*binomial(k-n-1, k))
           elif n-k < k then 
              return(binomial(n, n-k))
           end_if
        end_if;
        break;
     of DOM_RAT      do
     of DOM_COMPLEX  do
        if k < 0 then 
           return(0)
        end_if;
        break;
     end_case;
     // the special cases k = 0 and k = 1 were handled above
     nk1:= n - k - 1;
     return(n*_mult((nk1+i)/i $ i = 2..k));
     break;
  end_case:
  return(procname(n, k));
end_proc:

binomial := prog::remember(binomial, 
  () -> [property::depends(args()), DIGITS, slotAssignCounter("binomial")]):

binomial := funcenv(binomial):
binomial::type := "binomial":
binomial::print := "binomial":

binomial::float:= proc(n, k)
  local fn, fk, i, nk1;
begin
  if iszero(k) or iszero(k - n) then
     return(float(1))
  elif iszero(k - 1) or iszero(n - k - 1) then
     return(float(n))
  end_if;
  fn:= float(n):
  if domtype(fn) = DOM_FLOAT and iszero(frac(n)) then
     n:= round(n):
  end_if:
  fk:= float(k):
  if domtype(fk) = DOM_FLOAT and iszero(frac(k)) then
     k:= round(k):
  end_if:
  // Case 1: n = negative integer and k <> negative integer --> singularity
  // Case 2: k = negative integer --> the result is finite, but not n!/k!/(n-k)!
  // Case 3: n, k, n-k <> negative integer --> the result is n!/k!/(n-k)!
  if domtype(n) = DOM_INT and n < 0 then
     // n is a negative integer
     if domtype(k) <> DOM_INT then
        // k is not an integer
        error("singularity");
     else // k is an integer
        if k <= n then // k <= n < 0
           return(binomial::float(n, n - k));
        elif k < 0 then // k is a small negative integer
           return(float(0))
        elif k < 100 then // k is a small positive integer
            nk1:= n - k - 1:
            return(n*_mult( float((nk1+i)/i) $ i = 2..k));
        else // k is a large positive integer
            return((-1)^k*binomial::float(k - n - 1, k));
        end_if;
     end_if:
  else // n is not a negative integer
    if contains({DOM_FLOAT, DOM_COMPLEX}, domtype(fn)) then
       if domtype(k) = DOM_INT then
          if k < 0 then
             return(float(0));
          end_if:
          if domtype(n) = DOM_INT and n >= 0 and k <= n then
            // use binomial(n, k) = binomial(n, n - k) to make k small
            k:= min(k, n - k);
          end_if:
          if domtype(n) = DOM_INT and n >= 0 and k >= 0 and n-k < 0 then
             return(float(0))
          end_if;
          if k < 100 then
            nk1:= n - k - 1:
            return(n*_mult( float((nk1+i)/i) $ i = 2..k));
          end_if;
          return(gamma(float(n+1))/
                 gamma(float(k+1))/
                 gamma(float(n-k+1)));
       else // k is not an integer
         if contains({DOM_FLOAT, DOM_COMPLEX}, domtype(fk)) then
            if iszero(frac(n-k)) and 
               domtype(float(n - k)) = DOM_FLOAT and 
               n-k < 0 then
               return(float(0))
            else
               return(gamma(float(n+1))/
                      gamma(float(k+1))/
                      gamma(float(n-k+1)));
            end_if:
         end_if:
       end_if:
    end_if;
  end_if:
  return(hold(binomial)(fn, fk));
end_proc:

binomial::hull:=  (n, k) -> binomial(hull(n), hull(k)):

binomial::expand:=
   proc(b)
     local a, res, n, k;
   begin
     [n, k]:= [op(b)];
     if testtype(n-k, Type::NegInt) then
       k:= n-k
     end_if;
     if  testtype(k,Type::NegInt) then
       if testtype(n, Type::NonNegInt) then
         return(0)
       else
         // binomial(n, k) = binomial(n, k+1) *(k+1)/(n-k) for n <> k
         // we do not catch this problem using piecewise, but express e.g.
         // binomial(n, -1) as kroneckerDelta(n, -1)
         a:= 1;
         res:= 0;
         while k <= -1 do
           res:= res+ a*kroneckerDelta(n, k);
           a:= a*(k+1)/(n-k);
           k:= k+1
         end_while;
         return(res)
       end_if
     elif testtype(n, Type::NegInt) then
       // rewriting by gamma does not work here; we
       // tacitly assume that k is an integer, and use
       // binomial(n, k) = (-1)^k * binomial(k-n-1, k)
       return((-1)^k * expand(binomial(k-n-1, k)))
       //  elif contains(map({k,n-k,n},type),DOM_FLOAT) then
       //       expand(gamma(n+1)/gamma(k+1)/gamma(n-k))
       //  else expand(fact(n)/fact(k)/fact(n-k))         // do not use fact
     end_if;
     expand(gamma(n+1)/gamma(k+1)/gamma(n-k+1), args(2..args(0)))
   end_proc:

binomial::simplify :=
   proc(e) 
      local n, k;
   begin 
      n:= op(e,1); k:= op(e,2);

      if  testtype(n, Type::NonNegInt) and 
        (testtype(n-k,Type::NegInt) or testtype(k, Type::Negint)) then
        0
      else
        e
      end_if
   end_proc:

// series(binomial(f1, f2), x, n, dir)
binomial::series:=
proc(f1, f2, x, n, dir, opt)
begin 
   combine(Series::series(gamma(f1+1)/gamma(f2+1)/gamma(f1-f2+1), x, n, dir, opt))
end_proc:

// diff(binomial(f1, f2), x)
binomial::diff := proc(f, x)
  local f1, f2;
begin
  [f1, f2] := [op(f)];
  (diff(f1, x)*psi(f1 + 1) - diff(f2, x)*psi(f2 + 1) -
   diff(f1 - f2, x)*psi(f1 - f2 + 1))*f;
end_proc:

binomial::Content := stdlib::genOutFunc("Cbinomial", 2):

binomial::TeX := (env, ex, pri) -> "\\binom{".generate::TeX(op(ex,1)).
                                   "}{".generate::TeX(op(ex,2))."}":
