ceil := 
proc(a)
  option noDebug;
  save DIGITS;
begin
  if args(0) <> 1 then
    error("one argument expected")
  elif a::dom::ceil <> FAIL then
    return(a::dom::ceil(args()))
  end_if;

  case type(a)
    of DOM_INT do return(a);
    of DOM_RAT do
    of DOM_FLOAT do
      break;
    of DOM_SET do
    of "_union" do
      return(map(a, ceil))
    otherwise
      if not testtype(a,Type::Arithmetical) then
        /* generic handling of sets */
        if testtype(a, Type::Set) then
          if type(a)=Dom::ImageSet then
            return(map(a, ceil));
          else
            return(Dom::ImageSet(ceil(#a), #a, a));
          end_if;
        end_if;
	error("argument must be of 'Type::Arithmetical'")
      end_if;
  end_case;
  
  specfunc::ceil(a);
end_proc:

ceil:= funcenv(ceil):
ceil::type := "ceil":
ceil::print := "ceil":

ceil::float := specfunc::ceil:
ceil::hull := DOM_INTERVAL::ceil@hull:

ceil::simplify := 
proc(x)
  local iv, res;
begin
  iv := hull(op(x)) intersect hull(getprop(op(x)));
  if op(iv, 0) = hold(hull) then // real interval
   res := 0:
   if op(iv, 1) > RD_NINF then
     res := floor(op(iv,1)) + 1;
   elif op(iv, 2) < RD_INF then
     res := ceil(op(iv, 1));
   end_if;
   if is(op(x) <= res) = TRUE and
      is(op(x) > res-1) = TRUE then
     return(res);
   end_if;
  end_if;
  x;
end_proc:

ceil::undefined := {}:

ceil::realDiscont :=
  loadproc(ceil::realDiscont, pathname("STDLIB", "DISCONT"), "ceil" ):


ceil::rectform:=
  loadproc(ceil::rectform, pathname("STDLIB","RECTFORM"), "ceil"):


ceil::Content := stdlib::genOutFunc("Cceiling", 1):

ceil::TeX := (c, data, prio) -> "\\left\\lceil ".
			       generate::tex(op(data), output::Priority::Noop).
			       "\\right\\rceil ":

ceil::series := loadproc(ceil::series, pathname("SERIES"), "ceil"):
