/*++
cos -- the cosine

cos(x)

x - expression
++*/

cos:=
proc(x)
  option noDebug;
  local f, y;
begin
  if args(0) = 0 then error("no arguments given")
  elif x::dom::cos <> FAIL then return(x::dom::cos(args()))
  elif args(0) <> 1 then error("wrong no of args")
  end_if;

  case type(x)
    of DOM_INT do
    of DOM_RAT do
     if x < 0 then return(cos(-x)) end_if;
     break;

    of DOM_FLOAT do
     return(cos::float(x));

    of DOM_COMPLEX do
     if domtype(op(x,1)) = DOM_FLOAT or
        domtype(op(x,2)) = DOM_FLOAT then
            return(cos::float(x))
        end_if;
     if op(x,1) = 0 then return(cosh(-x*I)) end_if;
     break;
    of DOM_SET do
    of "_union" do
       return(map(x, cos))
    of "_intersect" do
    of "_minus" do
       return(Dom::ImageSet(cos(`#z`), `#z`, x))
  end_case;

  if not testtype(x,Type::Arithmetical) then
      /* generic handling of sets */
      if testtype(x, Type::Set) then
        return(Dom::ImageSet(cos(`#x`), `#x`, x));
      end_if;
      error("argument must be of type 'Type::Arithmetical'")
  end_if;

  case type(x)
    of "_mult" do
       f:= op(x, nops(x));
       if testtype(f, Type::Real) then
         if f < 0 then return(cos(-x)) end_if;
         if domtype(f) = DOM_FLOAT then break end_if;
       else
          break
       end_if;
       f:= x/PI;
       if contains({DOM_RAT, DOM_INT}, domtype(f)) then
         if f < 0 then return(cos(-x)) end_if;
         if f < 1/2 then break end_if;
         if f < 1 then return(-cos((1-f)*PI)) end_if;
         if f < 2 then return(cos((2-f)*PI)) end_if;
         return(cos((f-2*(floor(f) div 2))*PI));
       end_if;
       break;
    of "_plus" do
       // due to performance: move this code to cos::simplify
       // if sysorder(-x,x)=TRUE then return(cos(-x)) else break end_if

       // handle cos(y + integer*PI) -> (-1)^integer*cos(y)
       // We could also do cos(y + PI/2) -> -sin(y).
       // At the moment, we decide not to do it.
       if has(x, PI) then
          for y in x do
              f:= y/PI;
              if testtype(f, DOM_INT) and f<>0 then
                 return((-1)^f*cos(x-y))
              end_if;
          end_for:
       end_if:
       break;
    of "arcsin" do return(sqrt(1-op(x)^2));
    of "arccos" do return(op(x));
    of "arctan" do return(1/sqrt(1+op(x)^2));
    of "arccot" do x:= 1/op(x);
                   return(1/sqrt(1+x^2));
    of "arg" do 
       /* ------ 
       if nops(x) = 1 then
          [x, y]:= [Re(op(x)), Im(op(x))];
       elif nops(x) = 2 then
          [x, y]:= [op(x, 1), op(x, 2)];
       else
          break;
       end_if:
       if not iszero(x^2 + y^2) then
          return(x/sqrt(x^2 + y^2)):
       else
          return(1); // MuPAD defines arg(0) = 0
       end_if;
       ------ */
       return(Re(op(x))/abs(op(x))):
  end_case;

  procname(x)
end_proc:

cos := prog::remember(cos, 
  () -> [property::depends(args()), DIGITS, slotAssignCounter("cos")]):

cos(infinity):= undefined:
cos(-infinity):= undefined:
cos( hold(_mult)(I,infinity ) ):= infinity:
cos( hold(_mult)(-I,infinity) ):= infinity:

// cos(I):= cosh(1):
cos(0):= 1:
cos(PI):= -1:
cos(PI/2):= 0:
cos(PI/3):= 1/2:
cos(PI/4):= (2^(1/2))/2:
cos(PI/  5):= (5^(1/2)+1)/4:
cos(PI*2/5):= (5^(1/2)-1)/4:
cos(PI/6):= (3^(1/2))/2:
cos(PI/  8):= ((2+2^(1/2))^(1/2))/2:
cos(PI*3/8):= ((2-2^(1/2))^(1/2))/2:
cos(PI  /10):= 2^(1/2)/4*(5+5^(1/2))^(1/2):
cos(PI*3/10):= 2^(1/2)/4*(5-5^(1/2))^(1/2):
cos(PI/  12):= (6^(1/2)+2^(1/2))/4: // simpler than ((2+3^(1/2))^(1/2))/2:
cos(PI*5/12):= (6^(1/2)-2^(1/2))/4: // = ((2-3^(1/2))^(1/2))/2:

cos:= funcenv(cos, op(specfunc::cos, 2)):
cos::print := "cos":
cos::type := "cos":
cos::info := "cos -- the cosine":
cos::float := specfunc::cos:

stdlib::deferredAlias( cos::hull, DOM_INTERVAL::cos@hull ):

cos::inverse := "arccos":

cos::expand :=
    loadproc(cos::expand, pathname("STDLIB","EXPAND"),"cos"):

cos::conjugate :=
    loadproc(cos::conjugate, pathname("STDLIB","CONJ"),"cos"):

cos::rectform :=
    loadproc(cos::rectform, pathname("STDLIB","RECTFORM"),"cos"):

cos::simplify :=
    loadproc(cos::simplify, pathname("STDLIB","SIMPLIFY"),"cos"):

cos::series :=
    loadproc(cos::series, pathname("SERIES"),"cos"):

cos::Re :=
    loadproc(cos::Re, pathname("STDLIB","RE"),"cos"):

cos::Im :=
    loadproc(cos::Im, pathname("STDLIB","IM"),"cos"):

cos::diff :=
    loadproc(cos::diff, pathname("STDLIB","DIFF"),"cos"):

cos::"transform::laplace":=
    loadproc( cos::"transform::laplace",
        pathname("TRANS","LAPLACE"), "L_cos"):

cos::findRelations:= rationalize::findRelationsTrig:

cos::Content := stdlib::genOutFunc("Ccos", 1):

// end of file
