csch :=
proc(x)
  option noDebug;
  // csch(x) = 1/sinh(x) 
begin
  if args(0) = 0 then
    error("no arguments given")
  elif x::dom::csch <> FAIL then
    return(x::dom::csch(args()))
  elif args(0) <> 1 then
    error("1 argument expected")
  end_if;

  case type(x)
    of DOM_SET do
    of "_union" do
      return(map(x, csch))
  end_case;
  
  if not testtype(x,Type::Arithmetical) then
    /* generic handling of sets */
    if testtype(x, Type::Set) then
      return(Dom::ImageSet(csch(`#x`), `#x`, x));
    end_if;
    error("argument must be of 'Type::Arithmetical'")
  end_if;

  x:= sinh(x);
  if iszero(x) then
    error("singularity")
  else
    1/x
  end_if;
end_proc:

csch := funcenv(csch):
csch::type := "csch":
csch::print := "csch":
csch::info := "csch -- the hyperbolic cosecant":

csch::hull := DOM_INTERVAL::csch@hull:

csch::inverse := "arccsch":

csch::expand := x -> expand(1/sinh(op(x, 1)), args(2..args(0))):

csch::conjugate :=
    loadproc(csch::conjugate, pathname("STDLIB","CONJ"), "csch"):

csch::Content := stdlib::genOutFunc("Ccsch", 1):

// end of file 
