
dedekindEta:=
proc(t)
begin
  if args(0) <> 1 then
    error("wrong number of args")
  end_if;

  case type(t)
    of DOM_SET do
    of "_union" do
      return(map(t, dedekindEta))
  end_case;

  if not testtype(t, Type::Arithmetical) then
    /* generic handling of sets */
    if testtype(t, Type::Set) then
      if type(t)=Dom::ImageSet then
        return(map(t, dedekindEta));
      else
        return(Dom::ImageSet(dedekindEta(#t), #t, t));
      end_if;
    end_if;
    error("argument must be of 'Type::Arithmetical'")
  end_if;

  if testargs() then
    if contains({0, -1}, specfunc::sign(Im(t))) then
      error("argument must have positive imaginary part")
    end_if;
  end_if;

  case type(t)
    of DOM_FLOAT do
      return(dedekindEta::float(t))
    of DOM_COMPLEX do
      if type(op(t, 1)) = DOM_FLOAT then
        return(dedekindEta::float(t))
      else
        break
      end_if
  end_case;

  procname(t)
end_proc:

dedekindEta := prog::remember(dedekindEta, 
  () -> [property::depends(args()), DIGITS, slotAssignCounter("dedekindEta")]):

dedekindEta:= funcenv(dedekindEta): 

dedekindEta::type:= "dedekindEta":
dedekindEta::print:= "dedekindEta":



dedekindEta::float:=
proc(t)
  local c;
begin
  t:= float(t);
  if not contains({DOM_FLOAT, DOM_COMPLEX}, domtype(t)) then
    return(hold(DedekindEta)(t))
  end_if;
  
  if Im(t) <=0 then
    error("argument must have positive imaginary part")
  end_if;

  // if t is close to zero, apply the law
  // eta(t) = sqrt(I/t) * eta(-1/t)
  if specfunc::abs(t) < 0.5 then
    c:= sqrt(I/t);
    t:= -1/t
  else
    c:= 1.0
  end_if;
  
  c*float(exp(PI*I*t/12)) * specfunc::eulerQProduct(1, float(exp(2*PI*I*t)))
end_proc:

// end of file
