/*++
The Error function

erf(x)

x - an expression
++*/

erf :=
proc(x) 
  option noDebug;
begin
  if args(0) = 0 then error("no arguments given")
  elif x::dom::erf <> FAIL then return(x::dom::erf(args()))
  elif args(0) <> 1 then error("1 argument expected");
  end_if;

  case type(x)
    of DOM_FLOAT do
      return(erf::float(x));
    of DOM_COMPLEX do
      if type(op(x,1)) = DOM_FLOAT or type(op(x,2)) = DOM_FLOAT then
        return(erf::float(x));
      end_if;
      break;
    of DOM_SET do
    of "_union" do
      return(map(x, erf))
    of "inverf" do
      return(op(x, 1));
    of "inverfc" do
      return(1-op(x, 1));
    of "_mult" do
      if type(-x) = "inverf" then // erf(-inverf(x))
        return(-op(-x, 1))
      end_if;
      if type(-x) = "inverfc" then // erf(-inverfc(x)) = erf(inverfc(2-x))
                                   // erf(inverf(x - 1))
        return(op(-x, 1) - 1)
      end_if;
      break;
  end_case;
  
  if not testtype(x,Type::Arithmetical) then
    /* generic handling of sets */
    if testtype(x, Type::Set) then
      if type(x)=Dom::ImageSet then
        return(map(x, erf));
      else
        return(Dom::ImageSet(erf(#x), #x, x));
      end_if;
    end_if;

     error("argument must be of 'Type::Arithmetical'")
  end_if;

  if stdlib::hasmsign(x) then
    -procname(-x);
  else
    procname(x);
  end_if;

end_proc:

erf := prog::remember(erf, 
  () -> [property::depends(args()), DIGITS, slotAssignCounter("erf")]):

erf(0) := 0:
erf(infinity):=1:
erf(infinity*I):=infinity*I:
erf(-infinity):=-1:
erf(-infinity*I):=-infinity*I:
erf(RD_INF):=1:
erf(RD_INF*I):=RD_INF*I:
erf(RD_NINF):=-1:
erf(RD_NINF*I):=RD_NINF*I:
erf(RD_NAN):= RD_NAN:


erf:= funcenv(erf):
erf::print:= "erf":
erf::type:= "erf":
erf::info:= "erf -- the error function [try ?erf for details]":

erf::conjugate:=
    loadproc(erf::conjugate, pathname("STDLIB", "CONJ"), "erf"):

erf::diff:=
  proc(x)
    local op1;
  begin 
    op1 := op(x, 1);
    2/PI^(1/2) * exp(-op1^2) * diff(op1, args(2..args(0)))
  end_proc:

erf::float:=specfunc::erf:

erf::sign:= loadproc(erf::sign, pathname("SPECFUNC", "SIGN"), "erf"):

erf::series:= loadproc(erf::series, pathname("SERIES"), "erf"):

erf::rectform:= loadproc(erf::rectform, pathname("STDLIB", "RECTFORM"), "erf"):

erf::Re:= proc(x)
begin
  if is(x in R_) = TRUE then
     return(hold(erf)(x))
  elif is(x/I in R_) = TRUE then
     return(0)
  end_if;
  hold(Re)(erf(x));
end_proc:

erf::Im:= proc(x)
begin
  if is(x/I in R_) = TRUE then
     return(hold(erf)(x)/I)
  elif is(x in R_) = TRUE then
     return(0)
  end_if;
  hold(Im)(erf(x));
end_proc:


erf::getprop:=proc(xpr)
  local prop, l, r;
begin
  prop := getprop(op(xpr));
  case type(prop)
    of solvelib::BasicSet do
      if prop=C_ then return(C_); end_if;
      return(Dom::Interval(-1,1));
    of Dom::Interval do
      l := erf(Dom::Interval::left(prop));
      r := erf(Dom::Interval::right(prop));
      if not Dom::Interval::isleftopen(prop) then l := [l]; end_if;
      if not Dom::Interval::isrightopen(prop) then r := [r]; end_if;
      return(Dom::Interval(l,r));
  end_case;
  C_;
end_proc:

// end of file 
