/*++
The Imaginary Error function

erfi(x)

x - an expression
++*/

erfi :=
proc(x) 
  option noDebug;
begin
  if args(0) = 0 then error("no arguments given")
  elif x::dom::erfi <> FAIL then return(x::dom::erfi(args()))
  elif args(0) <> 1 then error("1 argument expected");
  end_if;

  case type(x)
    of DOM_FLOAT do
      return(erfi::float(x));
    of DOM_COMPLEX do
      if type(op(x,1)) = DOM_FLOAT or type(op(x,2)) = DOM_FLOAT then
        return(erfi::float(x));
      end_if;
      break;
    of DOM_SET do
    of "_union" do
      return(map(x, erfi))
  end_case;
  
  if not testtype(x,Type::Arithmetical) then
    /* generic handling of sets */
    if testtype(x, Type::Set) then
      if type(x)=Dom::ImageSet then
        return(map(x, erfi));
      else
        return(Dom::ImageSet(erfi(#x), #x, x));
      end_if;
    end_if;

     error("argument must be of 'Type::Arithmetical'")
  end_if;

  if stdlib::hasmsign(x) then
    -procname(-x);
  else
    procname(x);
  end_if;
end_proc:

erfi := prog::remember(erfi, 
  () -> [property::depends(args()), DIGITS, slotAssignCounter("erfi")]):

erfi(0) := 0:
erfi(infinity):= infinity:
erfi(infinity*I):= I:
erfi(-infinity):=-infinity:
erfi(-infinity*I):= -I:
erfi(RD_INF):= RD_INF:
erfi(RD_INF*I):= float(1)*I:
erfi(RD_NINF):= RD_NINF:
erfi(RD_NINF*I):= -float(1)*I:
erfi(RD_NAN):= RD_NAN:


erfi:= funcenv(erfi):
erfi::print:= "erfi":
erfi::type:= "erfi":
erfi::info:= "erfi -- the imaginary error function [try ?erfi for details]":

erfi::conjugate:=
    loadproc(erfi::conjugate, pathname("STDLIB", "CONJ"), "erfi"):

erfi::diff:=
  proc(x)
    local op1;
  begin 
    op1 := op(x, 1);
    2/PI^(1/2) * exp(op1^2) * diff(op1, args(2..args(0)))
  end_proc:

erfi::float:= proc(x)
begin
  x:= float(x):
  if domtype(x) = DOM_FLOAT or
     domtype(x) = DOM_COMPLEX then
     return(-I*erf(I*x))
  else
     return(hold(erfi)(x));
  end_if;
end_proc:

erfi::sign:= loadproc(erfi::sign, pathname("SPECFUNC", "SIGN"), "erfi"):

erfi::series:= loadproc(erfi::series, pathname("SERIES"), "erfi"):

erfi::Re:= (x) -> if is(x in R_) = TRUE then
                     return(hold(erfi)(x))
                  elif is(x/I in R_) = TRUE then
                     return(0)
                  else
                     return(hold(Re)(hold(erfi)(x)));
                  end_if:
erfi::Im:= (x) -> if is(x in R_) = TRUE then
                     return(0)
                  elif is(x/I in R_) = TRUE then
                     return(-hold(erfi)(x)*I)
                  else
                     return(hold(Im)(hold(erfi)(x)));
                  end_if:


erfi::rectform:= loadproc(erfi::rectform, pathname("STDLIB", "RECTFORM"), "erfi"):

// end of file 
