
/*
eulerQProduct(t, x)
 computes the product
prod_{k=1}^{\infty} (1-t*x^k)

this equals sum_{n=0}^{\infty} (-t)^nx^(n*(n+1)/2)/((1-x)*(1-x^2)*..*(1-x^n))

Source: Alan Sokal, Numerical computation of \prod (1- tx^n),
ArXiv:math.NA/0212035 v1 3.Dec 2002
*/

specfunc::eulerQProduct:=
proc(t, x)
  local summe, prod, xprod, xn, minN, gam, digits, n, an;
  save DIGITS;
begin
  if testargs() then
    if abs(x) >= 1 then
      error("second argument must have absolute value < 1")
    end_if
  end_if;

  if iszero(x) then
    return(1.0)
  end_if;
  
  summe:= 1.0;
  prod:= 1.0;
  xprod:= 1;
  xn:= 1;
  // we do not use the a-priori bound in that paper
  // compute minimal a-posteriori bound:
  gam:= abs(ln(abs(x)));
  minN:= ceil(ln(1 + 2*abs(t))/gam);
  digits:= DIGITS;
  DIGITS:= digits + ceil(1.07/gam);
  n:=0;
  repeat
    n:= n+1;
    xn:= xn*x; // now xn = x^n
    prod:= prod*(1-xn);
    xprod:= xprod*xn;
    // now xprod = x^(n*(n+1)/2)
    an:= (-t)^n*xprod/prod;
    summe:= summe + an;
  until n>minN and abs(an/summe) < 10^(-digits) end_repeat;
  summe
end_proc:

// end of file

