/*++
fact -- factorial function

fact(n)

n - expression
++*/

fact:=
proc(x)
begin
  if args(0) = 0 then
    error("no arguments given")
  elif x::dom::fact <> FAIL then
    return(x::dom::fact(args()))
  elif args(0) <> 1 then
    error("expecting one argument")
  end_if;

  case type(x)
    of DOM_INT do  
      if x < Pref::autoExpansionLimit() then
         return(specfunc::fact(x))
      else
         return(procname(args()));
      end_if;
    of DOM_SET do
    of "_union" do
      return(map(x, fact))
    of DOM_FLOAT do
      if iszero(frac(x)) and x > 0 then
         return(gamma(x + 1));
      end_if:
      error("the argument must be a positive integer")
    of DOM_COMPLEX do
    of DOM_RAT do
      error("the argument must be a positive integer")
  end_case;
  
  if not testtype(x,Type::Arithmetical) then
    /* generic handling of sets */
    if testtype(x, Type::Set) then
      if type(x)=Dom::ImageSet then
        return(map(x, fact));
      else
        return(Dom::ImageSet(fact(#x), #x, x));
      end_if;
    end_if;

    error("the argument must be of 'Type::Arithmetical'")
  else
    procname(args())
 end_if
end_proc:

fact := prog::remember(fact,
                       () -> [property::depends(args()),
                              Pref::autoExpansionLimit(),
                              slotAssignCounter("fact")]):

 fact:= funcenv(fact, builtin(1099, 1300, "!", "fact")):
 fact::print := "fact":
 fact::info  := "fact -- the factorial function":
 fact::type  := "fact":

 fact::expand:= loadproc(fact::expand, pathname("STDLIB","EXPAND"), "fact"):

 fact::diff  := (x, y) -> fact(op(x))*psi(op(x) + 1)*diff(op(x), y):

 fact::float := proc(x)
 begin
   if domtype(x) = DOM_INT then
     if x <= 1000 then
       return(float(specfunc::fact(x)))
     else
       return(gamma::float(x+1))
     end_if
   else
     return(hold(fact)(float(x)));
   end_if:
 end_proc:

 fact::series:= x -> gamma::series(x+1,args(2..args(0))):

 fact::rectform:= n -> new(rectform, fact(n), 0, 0):

 fact(FAIL)  := FAIL:

 fact::minprop:= Type::PosInt:

 fact::Content := stdlib::genOutFunc("Cfactorial", 1):

 fact::TeX := (f, ex, prio) -> generate::TeXquote(generate::tex(op(ex), output::Priority::Fact)."! ",
                                                  prio, output::Priority::Fact):

// end of file 
