/*++
fact2 -- double factorial function

fact2(n)

n - expression
++*/

fact2:=
proc(x)
  local i;
begin
  if args(0) = 0 then
    error("no arguments given")
  elif x::dom::fact2 <> FAIL then
    x::dom::fact2(args())
  elif args(0) <> 1 then
    error("expecting one argument")
  end_if;

  case type(x)
    of DOM_SET do
    of "_union" do
      return(map(x, fact2))
  end_case;
  
  if not testtype(x,Type::Arithmetical) then
    /* generic handling of sets */
    if testtype(x, Type::Set) then
      if type(x)=Dom::ImageSet then
        return(map(x, fact2));
      else
        return(Dom::ImageSet(fact2(#x), #x, x));
      end_if;
    end_if;

    error("argument must be of 'Type::Arithmetical'")
  end_if;

  if not testtype(x, Type::Numeric) then
    return(procname(x))
  end_if;

  if domtype(x) <> DOM_INT or x < -1 then
    error("Integer >= -1 expected")
  end_if;

  if x < Pref::autoExpansionLimit() then
    case modp(x, 2)
      of 0 do
        return(_mult(2*i $i=1..x div 2));
        break
      of 1 do
        return(_mult(2*i+1 $i=1..x div 2));
        break
    end_case  
  else
    return(procname(args()))
  end_if
end_proc:

fact2 := prog::remember(fact2,
                        () -> [property::depends(args()),
                               Pref::autoExpansionLimit(),
                               slotAssignCounter("fact2")]):

fact2:= funcenv(fact2, builtin(1099, 1300, "!!", "fact2")):
fact2::print := "fact2":
fact2::info  := "fact2 -- the double factorial function":
fact2::type  := "fact2":

fact2::float := proc(x) 
begin
   if domtype(x) = DOM_INT then
     return(float(2^(x/2)*(float(PI)/2)^(((-1)^x - 1)/4) *gamma(float(x/2 + 1))));
   else
     return(hold(fact2)(float(x)));
   end_if:
end_proc:

fact2::expand:= proc(e)
local x, y, i;
begin
    x:= op(e, 1);
    if domtype(x) = DOM_INT then  
      case modp(x, 2)
        of 0 do
          return(_mult(2*i $ i=1..x div 2));
          break
        of 1 do
          return(_mult(2*i+1 $ i=1..x div 2));
          break
      end_case  
    end_if:
    y:= expand(x);
    if y <> x then 
       return(fact2(y))
    else
       return(hold(fact2)(x));
    end_if:
end_proc:

fact2(FAIL)  := FAIL:

fact2::Content := stdlib::genOutFunc("Cfactorial2", 1):

fact2::TeX := (f, ex, prio) -> generate::TeXquote(generate::tex(op(ex),
                                                                output::Priority::Fact)."!! ",
                                                  prio, output::Priority::Fact):

// end of file 
