/*++
The Gamma function

gamma(x)

x - an expression
++*/


gamma :=
proc(x)
  local i,n;
  option noDebug;
begin
  if args(0) = 0 then
    error("no arguments given")
  elif x::dom::gamma <> FAIL then
    return(x::dom::gamma(args()))
  elif args(0) <> 1 then
    error("1 argument expected");
  end_if;

  case type(x)
    of DOM_FLOAT do
      if x <= 0 and iszero(frac(x)) then
        error("singularity");
      end_if;
      return(gamma::float(x));

    of DOM_INT do
      if x <= 0 then
        error("singularity");
      elif x <= Pref::autoExpansionLimit() then
        // gamma(x) = (x-1)! ,                 
        // but compute (x-1)! only if this produces no error
        return( fact(x-1) )
      else
        return(procname(args()));
      end_if;
      break;

    of DOM_COMPLEX do
      if domtype(op(x, 1)) = DOM_FLOAT or
        domtype(op(x, 2)) = DOM_FLOAT then
        return(gamma::float(x));
      end_if;
      break;
	   
    of DOM_RAT do
      if 1 < x and x <= Pref::autoExpansionLimit() then
        // compute (x-1)*gamma(x-1) only if x is not too large
        n:= trunc(x);
        return(_mult((x - i) $ i = 1 .. n) * gamma(x - n));
        // return( (x-1) * gamma(x-1) )
      elif x < 1/2 and
        (domtype(4*x) = DOM_INT or domtype(6*x) = DOM_INT) then
        return( level( PI * csc(PI*x) / gamma(1-x) ) )
      end_if;
      break;

    of DOM_SET do
    of "_union" do
      return(map(x, gamma))
  end_case;
  
  if not testtype(x,Type::Arithmetical) then
    /* generic handling of sets */
    if testtype(x, Type::Set) then
      if type(x)=Dom::ImageSet then
        return(map(x, gamma));
      else
        return(Dom::ImageSet(gamma(#x), #x, x));
      end_if;
    end_if;

    error("argument must be of 'Type::Arithmetical'")
  end_if;

  procname(x)
end_proc:

gamma := prog::remember(gamma,
  () -> [property::depends(args()), DIGITS, Pref::autoExpansionLimit(), slotAssignCounter("gamma")]):

gamma(1/2) := PI^(1/2):
gamma(infinity) := infinity:

gamma:= funcenv(gamma, op(specfunc::gamma, 2)):
gamma::print := "gamma":
gamma::info  := "gamma -- the Gamma function":
gamma::type  := "gamma":
gamma::float := specfunc::gamma:

gamma::hull  := DOM_INTERVAL::gamma@hull:

gamma::complexDiscont :=
   loadproc(gamma::complexDiscont, pathname("STDLIB", "DISCONT"), "gamma"):
gamma::realDiscont:= 
   loadproc(gamma::realDiscont,    pathname("STDLIB", "DISCONT"), "gamma"):
gamma::undefined := 
   loadproc(gamma::undefined,      pathname("STDLIB", "DISCONT"), "gamma"):

gamma::diff := proc()
                 local x;
               begin 
                 x := op(args(1),1);
                 diff(x, args(2..args(0))) * psi(x) * gamma(x)
               end_proc:

gamma::conjugate :=
    loadproc(gamma::conjugate, pathname("STDLIB","CONJ"),     "gamma"):

gamma::expand :=
    loadproc(gamma::expand,    pathname("STDLIB","EXPAND"),   "gamma"):

gamma::rectform :=
    loadproc(gamma::rectform,  pathname("STDLIB","RECTFORM"), "gamma"):

gamma::series :=
    loadproc(gamma::series,    pathname("SERIES"),            "gamma"):

gamma::Content := stdlib::genOutFunc("Cgamma", 1):

gamma::TeX := (g, data, prio) -> "\\Gamma\\left(".
				generate::tex(op(data), output::Priority::Noop).
				"\\right)":

// end of file 
