jacobiZeta:=
proc(u,m)
begin
  if args(0)<>2 then
    error("expecting 2 arguments");
  end_if;
  
  if iszero(u) or iszero(m) then
    if u = float(0) or m = float(0) then
     return(float(0));
    else
     return(0);
    end_if:
  end_if;

  if iszero(m-1) then
    return(tanh(u));
  end_if;

  if type(u)=DOM_FLOAT or (type(u)=DOM_COMPLEX and (type(op(u,1))=DOM_FLOAT or type(op(u,2))=DOM_FLOAT)) or
     type(m)=DOM_FLOAT or (type(m)=DOM_COMPLEX and (type(op(m,1))=DOM_FLOAT or type(op(m,2))=DOM_FLOAT)) then
    return(jacobiZeta::float(u,m));
  end_if;

  if not testtype(u,Type::Arithmetical) then
    if testtype(u, Type::Set) then
      if testtype(m, Type::Set) and not testtype(m, Type::Arithmetical) then
        return(Dom::ImageSet(eval(procname)(#u, #m), [#u, #m], [u, m]));
      else
        return(Dom::ImageSet(eval(procname)(#u, m), [#u], [u]));
      end_if;
    end_if;

    error("first argument must be of 'Type::Arithmetical'");
  end_if;

  if not testtype(m,Type::Arithmetical) then
    if testtype(m, Type::Set) then
      return(Dom::ImageSet(eval(procname)(u, #m), [#m], [m]));
    end_if;

    error("second argument must be of 'Type::Arithmetical'")
  end_if;

  return(procname(u,m));
end_proc:

jacobiZeta := prog::remember(jacobiZeta, 
  () -> [property::depends(args()), DIGITS, slotAssignCounter("jacobiZeta")]):

jacobiZeta:=funcenv(jacobiZeta):

jacobiZeta::type:="jacobiZeta":

jacobiZeta::Content := stdlib::genOutFunc("CjacobiZeta", 2):

jacobiZeta::diff:=proc(f)
local u,m,Km,Em,Eu,sn,cd,dn;
begin
  u:=op(f,1);
  m:=op(f,2);

  Km:=ellipticK(m);
  Em:=ellipticE(m);
  Eu:=ellipticE(jacobiAM(u,m),m);
  sn:=jacobiSN(u,m);
  cd:=jacobiCD(u,m);
  dn:=jacobiDN(u,m);

  return(
    diff(u,args(2..args(0))) * (jacobiDN(u,m)^2 - Em/Km) + 
    diff(m,args(2..args(0))) * (Eu/m/2 + dn^2/2*(u/m+sn*cd/(1-m)-Eu/m/(1-m)) - u/m*(Em/Km - Em^2/Km^2/(1-m)/2) )
  );
end_proc:

jacobiZeta::float_internal:=proc(u,m,eps)
local k1,Zscd,d;
begin
  if specfunc::abs(m)<eps then
    return([0.0, sin(u), cos(u), 1.0]);
  end_if;

  k1:=m/(1+sqrt(1-m))^2;
  Zscd:=jacobiZeta::float_internal(u/(1+k1), k1^2, eps);

  d:=1+k1*Zscd[2]^2;

  return(
      [(Zscd[1] + k1*Zscd[2]*Zscd[3]*Zscd[4]/d) * 2 / (1+k1),   // Z(u|m)
       (1+k1)*Zscd[2]/d,                                        // sn(u|m)
       Zscd[3]*Zscd[4]/d,                                       // cn(u|m)
       (1-k1*Zscd[2]^2)/d]                                      // dn(u|m)
    );
end_proc:

jacobiZeta::float:=proc(u,m)
begin
  u:=float(u);
  m:=float(m);
  if (type(u)<>DOM_FLOAT and type(u)<>DOM_COMPLEX) or (type(m)<>DOM_FLOAT and type(m)<>DOM_COMPLEX) then
    return(hold(jacobiZeta)(u,m));
  end_if;

  if iszero(m-1) then
    return(tanh(u));
  end_if;

  return(jacobiZeta::float_internal(u, m, float(10^(-DIGITS)))[1]);
end_proc:
