// 
sec :=
proc(x)
    option noDebug;
    // sec(x) = 1/cos(x) 
begin
  if args(0) = 0 then
    error("no arguments given")
  elif x::dom::sec <> FAIL then
    return(x::dom::sec(args()))
  elif args(0) <> 1 then
    error("1 argument expected")
  end_if;

  case type(x)
    of DOM_SET do
    of "_union" do  
      return(map(x, sec))  
  end_case;
      
  
  if not testtype(x,Type::Arithmetical) then
    /* generic handling of sets */
    if testtype(x, Type::Set) then
      return(Dom::ImageSet(sec(#x), #x, x));
    end_if;

    error("argument must be of 'Type::Arithmetical'")
  end_if;
    
  x:= cos(x);
  if iszero(x) then
    error("singularity")
  else
    1/x
  end_if;
end_proc:

sec := funcenv(sec):
sec::type := "sec":
sec::print := "sec":
sec::info := "sec -- the secant":

sec::hull := DOM_INTERVAL::sec@hull:

sec::inverse := "arcsec":

sec::expand := x-> expand(1/cos(op(x, 1)), args(2..args(0))):

sec::conjugate :=
    loadproc(sec::conjugate, pathname("STDLIB","CONJ"), "sec"):

sec::Content := stdlib::genOutFunc("Csec", 1):

// end of file 
