/*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

signIm -- indicates the position of a number in the complex plane:
             signIm(z) = +1  <--> z is in the upper half plane
             signIm(z) = -1  <--> z is in the lower half plane
             signIm(z) =  0  <--> z = 0

Im(z)>0               --> signIm(z) = 1        +  |   +
Im(z)=0 and Re(z)<0   --> signIm(z) = 1           |______
Im(z)=0 and Re(z)>0   --> signIm(z) =-1      -----o
Im(z)<0               --> signIm(z) =-1        -  |   -
z = 0                 --> signIm(z) = 0           |

Call:      signIm(z)
Parameter: z - arithmetical expression representing a complex number
Returns:   +1 or -1 or 0 or an unevaluated call

Following attributes are missing:
 -- rectform
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

signIm:=
proc(x)
  option noDebug;
  local Rex, Imx, s;
begin
  if args(0) = 0 then error("no arguments given")
  elif x::dom::signIm <> FAIL then return(x::dom::signIm(args()))
  elif args(0) <> 1 then error("wrong no of args")
  end_if;

  case type(x)
    of DOM_SET do
    of "_union" do
      return(map(x, signIm))
  end_case;

  if not testtype(x,Type::Arithmetical) then
    /* generic handling of sets */
    if testtype(x, Type::Set) then
      if type(x)=Dom::ImageSet then
        return(map(x, signIm));
      else
        return(Dom::ImageSet(signIm(#x), #x, x));
      end_if;
    end_if;

    error("argument must be of 'Type::Arithmetical'")
  end_if;

  case type(x)
    of DOM_INT do
    of DOM_RAT do
    of DOM_FLOAT do
      if x < 0 then
           return(1)
      elif x > 0 then
           return(-1)
      else return(0);
      end_if:
    of DOM_INTERVAL do
      s := {};
      Rex:= sign(Re(x)):
      Imx:= sign(Im(x)):
      if 1 in Imx then
        s := s union hull(1)
      end_if;
      if -1 in Imx then
        s := s union hull(-1)
      end_if;
      if 0 in Imx then
        if -1 in Rex then
          s := s union hull(1);
        end_if;
        if 1 in Rex then
          s := s union hull(-1);
        end_if;
        if 0 in Rex then
          s := s union hull(0);
        end_if;
      end_if;
      return(s);
    of DOM_COMPLEX do
      Rex:= op(x, 1):
      Imx:= op(x, 2):
      if Imx > 0 then
           return(1)
      elif Imx < 0 then
           return(-1)
      elif Rex <0  then // Im(x)=0 and Re(x)<0 -->  1
           return(1)
      elif Rex >0  then // Im(x)=0 and Re(x)>0 --> -1
           return(-1)
      else return(0)    // z = 0 --> 0
      end_if:
  end_case;
  // Now process symbolic input
  Imx:= Im(x):
  if is(Imx>0)= TRUE or
     is(x<0) = TRUE or
     (is(Imx >=0) = TRUE and is(Re(x)<0) = TRUE) then
     return(1)
  elif is(Imx<0)=TRUE or
       is(x>0)=TRUE or
       (is(Imx <=0)=TRUE and is(Re(x)>0)=TRUE) then
       return(-1)
  elif is(x=0)=TRUE then
     return(0)
  else
     if type(x)="_mult" then
      s := split( [op(x)], X->is(X>0, Goal=TRUE) );
      s := map( s[2], proc(X)
        begin
          if type(X)=DOM_COMPLEX and op(X,1)=0 then
            if op(X,2)>0 then
              I;
            elif op(X,2)<0 then
              -I;
            else
              X;
            end_if;
          elif is(X < 0, Goal = TRUE) then 
            -1
          else
            X;
          end_if
        end_proc );
      x := _mult( op(s) );
     end_if;
     // implement symmetry signIm(-x) = - signIm(x)
     if stdlib::hasmsign(x) then
          return(-procname(-x));
     else return(procname(x));
     end_if;
  end_if:
end_proc:

signIm := prog::remember(signIm, 
  () -> [property::depends(args()), DIGITS, slotAssignCounter("signIm")]):

signIm:= funcenv(signIm):
signIm::print:= "signIm":
signIm::info:= "signIm -- sign of the imaginary part of a number":
signIm::type:= "signIm":
signIm::float:= x -> signIm(float(x)):
signIm::conjugate:= signIm:
signIm::Re:= signIm:
signIm::Im:= 0:
signIm::diff:= 0: // regard signIm(x) as a constant function
signIm::series:= // treat signIm(x) as leading order term
  proc(f, x, n, dir, opt) // opt not used
  begin
    return(Series::Puiseux::const(signIm(f), x, n, dir))
  end_proc:

// minimal property
signIm::getprop := {-1,0,1}:

//rectform attribute still missing
//signIm::rectform:=
//    loadproc(signIm::rectform, pathname("STDLIB", "RECTFORM"), "signIm"):

// end of file
