/*++
sin -- the sine

sin(x)

x - expression
++*/

sin:=
proc(x)
  option noDebug;
  local f, y;
begin
  if args(0) = 0 then error("no arguments given")
  elif x::dom::sin <> FAIL then return(x::dom::sin(args()))
  elif args(0) <> 1 then error("wrong no of args")
  end_if;

  case type(x)
    of DOM_INT do
    of DOM_RAT do
      if x < 0 then return(-sin(-x)) end_if;
      break;

    of DOM_FLOAT do
      return(sin::float(x));

    of DOM_COMPLEX do
      if domtype(op(x,1)) = DOM_FLOAT or
         domtype(op(x,2)) = DOM_FLOAT then
        return(sin::float(x))
      end_if;
      if op(x,1) = 0 then return(sinh(-x*I)*I) end_if;
      break;

    of DOM_SET do
    of "_union" do
       return(map(x, sin))
    of "_intersect" do
    of "_minus" do
       return(Dom::ImageSet(sin(`#z`), `#z`, x))
  end_case;

  if not testtype(x,Type::Arithmetical) then
    if testtype(x, Type::Set) then
       return(Dom::ImageSet(sin(`#x`), `#x`, x));
    end_if;
    error("argument must be of 'Type::Arithmetical'")
  end_if;

  case type(x)
  of "_mult" do
     f:= op(x, nops(x));
     if testtype(f, Type::Real) then
       if f < 0 then return(-sin(-x)) end_if;
       if domtype(f) = DOM_FLOAT then break end_if;
     else
       break
     end_if;

     f:= x/PI;
     if contains({DOM_RAT, DOM_INT}, domtype(f)) then
        if f < 0 then return(-sin(-x)) end_if;
        if f < 1/2 then break end_if;
        if f < 1 then return(sin((1-f)*PI)) end_if;
        if f < 2 then return(-sin((2-f)*PI)) end_if;
        return(sin((f-2*(floor(f) div 2))*PI));
     end_if;
     break;
  of "_plus" do
     // due to performance: move this code to sin::simplify
     // if sysorder(-x,x)=TRUE then return(-sin(-x)) else break end_if

     // handle sin(y + integer*PI) -> (-1)^integer*sin(y)
     // We could also do sin(y + PI/2) -> -cos(y).
     // At the moment, we decide not to do it.
     if has(x, PI) then
        for y in x do
            f:= y/PI;
            if testtype(f, DOM_INT) and f<>0 then
               return((-1)^f*sin(x-y))
            end_if;
        end_for:
     end_if:
     break;
  of "arcsin" do return(op(x));
  of "arccos" do return(sqrt(1-op(x)^2));
  of "arctan" do return(op(x)/sqrt(1+op(x)^2));
  of "arccot" do x:= 1/op(x):
     return(x/sqrt(1+x^2));
  of "arg" do
   /* -------
     if nops(x) = 1 then
        [x, y]:= [Re(op(x)), Im(op(x))];
     elif nops(x) = 2 then
        [x, y]:= [op(x, 1), op(x, 2)];
     else
        break;
     end_if:
     if not iszero(x^2 + y^2) then 
        return(y/sqrt(x^2 + y^2)):
        return(y/sqrt(x^2 + y^2)):
     else 
        return(0); // MuPAD defines arg(0) = 0
     end_if;
     --- */
     return(Im(op(x))/abs(op(x))):
  end_case;

  procname(x)
end_proc:

sin := prog::remember(sin, 
  () -> [property::depends(args()), DIGITS, slotAssignCounter("sin")]):

sin(infinity):= undefined:
sin(-infinity):= undefined:
sin( hold(_mult)(I,infinity ) ):= hold(_mult)(I,infinity ):
sin( hold(_mult)(-I,infinity) ):= hold(_mult)(-I,infinity):

// sin(I):= sinh(1)*I:
sin(0):= 0:
sin(PI):= 0:
sin(PI/2):= 1:
sin(PI/3):= (3^(1/2))/2:
sin(PI/4):= (2^(1/2))/2:
sin(PI/  5):= 1/4*2^(1/2)*(5-5^(1/2))^(1/2):
sin(PI*2/5):= 1/4*2^(1/2)*(5+5^(1/2))^(1/2):
sin(PI/6):= 1/2:
sin(PI/  8):= ((2-2^(1/2))^(1/2))/2:
sin(PI*3/8):= ((2+2^(1/2))^(1/2))/2:
sin(PI/  10):= 1/4*(5^(1/2)-1):
sin(PI*3/10):= 1/4*(5^(1/2)+1):
sin(PI/  12):= (6^(1/2)-2^(1/2))/4: // simpler than ((2-3^(1/2))^(1/2))/2:
sin(PI*5/12):= (2^(1/2)+6^(1/2))/4: // = ((2+3^(1/2))^(1/2))/2:

sin:= funcenv(sin, op(specfunc::sin, 2)):
sin::print:= "sin":
sin::info:= "sin -- the sine":
sin::type:= "sin":
sin::float:= specfunc::sin:
stdlib::deferredAlias( sin::hull, DOM_INTERVAL::sin@hull ):

sin::findRelations:= rationalize::findRelationsTrig:


sin::inverse := "arcsin":

sin::expand :=
  loadproc(sin::expand, pathname("STDLIB","EXPAND"),"sin"):

sin::conjugate :=
  loadproc(sin::conjugate, pathname("STDLIB","CONJ"),"sin"):

sin::rectform :=
  loadproc(sin::rectform, pathname("STDLIB","RECTFORM"),"sin"):

sin::simplify :=
  loadproc(sin::simplify, pathname("STDLIB","SIMPLIFY"),"sin"):

sin::series :=
  loadproc(sin::series, pathname("SERIES"),"sin"):

sin::Re :=
  loadproc(sin::Re, pathname("STDLIB","RE"),"sin"):

sin::Im :=
  loadproc(sin::Im, pathname("STDLIB","IM"),"sin"):

sin::diff :=
  loadproc(sin::diff, pathname("STDLIB","DIFF"),"sin"):

sin::"transform::laplace":=
    loadproc( sin::"transform::laplace",
        pathname("TRANS","LAPLACE"), "L_sin"):

sin::findRelations:= rationalize::findRelationsTrig:

sin::Content := stdlib::genOutFunc("Csin", 1):

// end of file
