/*++
tan -- the tangens

tan(x)

x - expression
++*/

tan:=
proc(x)
  option noDebug;
  local f, y;
begin
  if args(0) = 0 then error("no arguments given")
  elif x::dom::tan <> FAIL then return(x::dom::tan(args()))
  elif args(0) <> 1 then error("wrong no of args") 
  end_if;

  case type(x)
    of DOM_INT do
    of DOM_RAT do
      if x < 0 then return(-tan(-x)) end_if;
      break;
    of DOM_FLOAT do
      return(tan::float(x));
    of DOM_COMPLEX do
      if domtype(op(x,1)) = DOM_FLOAT or
         domtype(op(x,2)) = DOM_FLOAT then
           return(tan::float(x))
      end_if;
      if op(x,1) = 0 then return(tanh(-x*I)*I) end_if;
      break;
    of DOM_SET do
    of "_union" do
       return(map(x, tan))
    of "_intersect" do
    of "_minus" do
       return(Dom::ImageSet(tan(`#z`), `#z`, x))
  end_case;

  if not testtype(x,Type::Arithmetical) then
    /* generic handling of sets */
    if testtype(x, Type::Set) then
      return(Dom::ImageSet(tan(#x), #x, x));
    end_if;
    error("argument must be of 'Type::Arithmetical'")
  end_if;

  case type(x)
  of "_mult" do
     f:= op(x, nops(x));
     if testtype(f, Type::Real) then
        if f < 0 then return(-tan(-x)) end_if;
        if domtype(f) = DOM_FLOAT then break end_if;
     else
        break
     end_if;
     f:= x/PI;
     if contains({DOM_RAT, DOM_INT}, domtype(f)) then
        if f < 0 then return(-tan(-x)) end_if;
        if f < 1/2 then break end_if;
        if f = 1/2 then error("singularity") end_if;
        if f < 1 then return(-tan((1-f)*PI)) end_if;
        if f < 2 then return(tan((f-1)*PI)) end_if;
        return(tan((f-floor(f))*PI));
     end_if;
     break;
  of "_plus" do
     // due to performance: move this code to tan::simplify
     // if sysorder(-x,x)=TRUE then return(-tan(-x)) else break end_if

     // handle tan(y + integer*PI) -> tan(y)
     // We could also do tan(y + PI/2) -> -cot(y).
     // At the moment, we decide not to do it.
     if has(x, PI) then
        for y in x do
            f:= y/PI;
            if testtype(f, DOM_INT) and f<>0 then
               return(tan(x-y))
            end_if;
        end_for:
     end_if:
     break;
  of "arctan" do return(op(x));
  of "arccot" do return(1/op(x));
  of "arcsin" do return(op(x) / sqrt(1-op(x)^2));
  of "arccos" do return(sqrt(1-op(x)^2) / op(x));
  of "arg" do
     if nops(x) = 1 then
        [x, y]:= [Re(op(x)), Im(op(x))];
     elif nops(x) = 2 then
        [x, y]:= [op(x, 1), op(x, 2)];
     else
        break;
     end_if:
     if iszero(x) then
        error("singularity");
     end_if;
     return(y/x)
  end_case;

  procname(x)
end_proc:

tan := prog::remember(tan, 
  () -> [property::depends(args()), DIGITS, slotAssignCounter("tan")]):

tan(infinity):= undefined:
tan(-infinity):= undefined:
tan(I*infinity):= I:
tan(-I*infinity):= -I:

tan(   0   ):= 0:
tan(  PI/3 ):= (3^(1/2)):
tan(  PI/4 ):= 1:
tan(  PI/5 ):= (5 - 2*5^(1/2))^(1/2):
tan(2*PI/5 ):= (1 + 5^(1/2)) * (2*5^(1/2) + 10)^(1/2)/4:
tan(  PI/6 ):= (3^(1/2))/3:
tan(  PI/8 ):= 2^(1/2)-1:
tan(3*PI/8 ):= 2^(1/2)+1:
tan(  PI/10):= 1/5*5^(1/2)*(5 - 2*5^(1/2))^(1/2):
tan(3*PI/10):= 1/5*5^(1/2)*(5 + 2*5^(1/2))^(1/2):
tan(  PI/12):= 2-3^(1/2):
tan(5*PI/12):= 2+3^(1/2):
tan(   PI/24):= -2 + 2^(1/2) - 3^(1/2) + 2^(1/2)*3^(1/2):
tan( 5*PI/24):= -2 - 2^(1/2) + 3^(1/2) + 2^(1/2)*3^(1/2):
tan( 7*PI/24):=  2 - 2^(1/2) - 3^(1/2) + 2^(1/2)*3^(1/2):
tan(11*PI/24):=  2 + 2^(1/2) + 3^(1/2) + 2^(1/2)*3^(1/2):
tan(PI):= 0:
tan(I):= tanh(1)*I:

tan:= funcenv(tan, op(specfunc::tan, 2)):
tan::print := "tan":
tan::info := "tan -- the tangens":
tan::type := "tan":
tan::float := specfunc::tan:

tan::hull := DOM_INTERVAL::tan@hull:

tan::inverse := "arctan":

tan::realDiscont:= loadproc(tan::realDiscont, pathname("STDLIB", "DISCONT"),
                            "tan"):

tan::complexDiscont:= loadproc(tan::complexDiscont, pathname("STDLIB",
                                                             "DISCONT"),
                            "tan"):
tan::undefined:= loadproc(tan::undefined, pathname("STDLIB", "DISCONT"),
                            "tan"):

tan::diff :=
  proc(f)
    local op1;
  begin
    op1 := op(f,1);
    diff(op1, args(2..args(0))) *(1+tan(op1)^2)
    // tan is better than cos because it does not introduce a new function 
  end_proc:

tan::expand:=
    loadproc(tan::expand, pathname("STDLIB", "EXPAND"), "tan"):

tan::conjugate :=
    loadproc(tan::conjugate, pathname("STDLIB","CONJ"),"tan"):

tan::rectform := 
    loadproc(tan::rectform, pathname("STDLIB","RECTFORM"),"tan"):

tan::simplify :=
    loadproc(tan::simplify, pathname("STDLIB","SIMPLIFY"),"tan"):

tan::series := // Stephan Huckemann Feb.5/ 2002
    loadproc(tan::series, pathname("SERIES"),"tan"):

tan::Re := loadproc(tan::Re, pathname("STDLIB","RE"),"tan"):

tan::Im := loadproc(tan::Im, pathname("STDLIB","IM"),"tan"):

tan::Content := stdlib::genOutFunc("Ctan", 1):

// end of file 
