// 
// PARI's trunc is ok, but we still need an interface function
// to handle sets ;-(

trunc := proc(a)
  option noDebug;
  save DIGITS;
begin
  if args(0) <> 1 then
    error("one argument expected")
  elif a::dom::trunc <> FAIL then
    return(a::dom::trunc(args()))
  end_if;

  case type(a)
    of DOM_INT do return(a);
    of DOM_RAT do
    of DOM_FLOAT do
    of DOM_COMPLEX do
       return(specfunc::trunc(a));
    of DOM_SET do
    of "_union" do
       return(map(a, trunc))
  end_case;
  
  if not testtype(a,Type::Arithmetical) then
    /* generic handling of sets */
    if testtype(a, Type::Set) then
      if type(a)=Dom::ImageSet then
        return(map(a, trunc));
      else
        return(Dom::ImageSet(trunc(#a), #a, a));
      end_if;
    end_if;

     error("argument must be of 'Type::Arithmetical'")
  end_if;

  specfunc::trunc(a):
end_proc:

trunc:= funcenv(trunc):
trunc::type:= "trunc":

trunc::float:= specfunc::trunc:

trunc::hull:= hull@DOM_INTERVAL::trunc@hull:

trunc::undefined:= {}:
trunc::realDiscont:=
    loadproc(trunc::realDiscont, pathname("STDLIB", "DISCONT"), "trunc"):

trunc::rectform:=
  loadproc(trunc::rectform, pathname("STDLIB","RECTFORM"), "trunc"):


trunc::series:=
	loadproc(trunc::series, pathname("SERIES"), "trunc"):

