
/* --------------------------------------------------
Walter Oevel, 8.7.01
  - stark ueberarbeitet, Funktionalitaetsaenderungen:
     x symbolic       --> symbolic call
     n an integer < 1 --> error
     n not an integer --> symbolic call or explicit, if x < 2
     In all other cases (n  = integer >=1, x numeric) an
     explicit expression is returned.
     This is a float, if
          x = float and p = convertible to a float
     It is a symbolic expression, if
          x <> float or p not convertible to a float
     
  - for numerical x <= 0 or x >= n, now values 0
    and 1, respectively, are returned even if
    p is symbolic.

  - Todo: - a bit more internal documentation (comments
            in the header) would be nice
          - Apart from this: OK
-------------------------------------------------- */

stats::binomialCDF:=proc(n, p)
local fp, fn;
option escape;
begin
  if args(0) <> 2 then
     error("expecting two arguments")
  end_if:

  // check the parameters at the time when the
  // function is generated

  // ------------- check p -------------
  fp:= float(p):
  if domtype(fp) = DOM_FLOAT then
     if fp < 0 or fp > 1 then
        error("the 'probability parameter' p must satisfy 0 <= p <= 1"):
     end_if;
  end_if;
  if domtype(fp) = DOM_COMPLEX then
     error("the 'probability parameter' must be real"):
  end_if;

  // ------------- check n -------------
  fn:= float(n);
  if domtype(n) = DOM_INT and n < 1 then
     error("the 'trial parameter' must be symbolic or an integer >= 1"):
  end_if;
  if domtype(fn) = DOM_FLOAT and domtype(n) <> DOM_INT then
     error("the 'trial parameter' must be symbolic or an integer >= 1"):
  end_if;
  if domtype(fn) = DOM_COMPLEX then
     error("the 'trial parameter' must be real"):
  end_if;

  //-------------------------------
  // return the following procedure
  //-------------------------------
  proc(x)
  local s, k, nn, pp, fp, qq, tmp, fx, tx, tnx, fnx;
  begin
    if args(0)<>1 then
       error("expecting one argument")
    end_if:

    // ---------------------------------------------
    // DO NOT MESS UP THE ORDERING OF THE FOLLWING 
    // CHECKS! YOU WILL CHANGE THE FUNCTIONALITY!
    // ---------------------------------------------

    // double check the parameters n and p. They
    // might have changed since this procedure was
    // created:

    // ------------- check p -------------
    pp:= context(p):
    fp:= float(pp):
    if domtype(fp) = DOM_FLOAT then
       if fp < 0 or fp > 1 then
          error("the 'probability parameter' p must satisfy 0 <= p <= 1"):
       end_if;
    end_if;
    if domtype(fp) = DOM_COMPLEX then
       error("the 'probability parameter' must be real"):
    end_if;

    // ------------- check n -------------
    nn:= context(n):
    if domtype(nn) = DOM_INT and nn < 1 then
       error("the 'trial parameter' must be symbolic or an integer >= 1"):
    end_if;
    if domtype(float(nn)) = DOM_FLOAT and domtype(nn) <> DOM_INT then
       error("the 'trial parameter' must be symbolic or an integer >= 1"):
    end_if;
    if domtype(float(nn)) = DOM_COMPLEX then
       error("the 'trial parameter' must be real"):
    end_if;

    // -------------- check x ---------------
    if x = -infinity then return(0); end_if;
    if x =  infinity then return(1); end_if;
    fx:= float(x):
    // -------------- check x < 2 ---------------
    if domtype(fx) = DOM_FLOAT then
       // P(X <= x) = sum(binomial(n, k)*p^k*q^(n-k), k = 0..min(n, trunc(x))) 
       //           =  q^n + n*p*q^(n-1) + ...
       // We assume n >= 1.
       // If x < 0, then min(n, trunc(x)) < 0 
       // If 0<= x < 1, then min(n, trunc(x)) = 0 
       // If 1<= x < 2, then min(n, trunc(x)) = 1 
       // If 2<= x then min(n, trunc(x)) cannot be simplified unless
       // n is numerical.
       // Hence return an explicit result for x < 2 for any n:
       if fx < 0 then
          if domtype(x) = DOM_FLOAT then
               return(float(0))
          else return(0)
          end_if;
       end_if;
       if fx < 1 then
          if domtype(x) = DOM_FLOAT then
               qq:= float(1 - pp):
               return(float(qq^nn))
          else return((1 - pp)^nn)
          end_if;
       end_if;
       if fx < 2 then
          if domtype(x) = DOM_FLOAT then
               qq:= float(1 - pp):
               pp:= float(pp):
               return(float( qq^nn + nn*qq^(nn-1)*pp))
          else return((1-pp)^nn + nn*(1 - pp)^(nn-1)*pp)
          end_if;
       end_if;
    end_if;

    // -------------- check x >= n - 2 ---------------
    // this is for calls such as binomialCDF(n, p)(n - 1)
    fnx:= float(nn - x):
    if domtype(fnx) = DOM_FLOAT then
       if fnx <= 0 then
          if domtype(x) = DOM_FLOAT then
               return(float(1))
          else return(1)
          end_if;
       end_if;
       if fnx <= 1 then
          if domtype(x) = DOM_FLOAT then
               return(float(1 - float(pp)^nn))
          else return(1 - pp^nn)
          end_if;
       end_if;
       if fnx <= 2 then
          if domtype(x) = DOM_FLOAT then
               qq:= float(1 - pp):
               pp:= float(pp):
               return(float(1 -  pp^nn - nn*pp^(nn-1)*qq))
          else return(1 - pp^nn - nn*pp^(nn-1)*(1 - pp))
          end_if;
       end_if;
    end_if;

    // ------------- double check n -------------
    if domtype(nn) <> DOM_INT then
       // n is not an integer
       return(hold(stats::binomialCDF)(nn, pp)(x));
    end_if;

    //---------------------------------------------
    // now we are sure that n is an integer >= 1
    //---------------------------------------------

    // ------------- check x -------------
    if domtype(fx) <> DOM_FLOAT then
       // x is symbolic, nothing can be done
       return(hold(stats::binomialCDF)(nn, pp)(x));
    end_if;

    // produce a floating point result? 
    // If so, convert pp and qq to floats for speed
    if domtype(x) = DOM_FLOAT then
         qq:= float(1 - pp):
         pp:= fp;
         tmp:= float(1):
    else qq:= 1 - pp;
         tmp:= 1:
    end_if: 

    //---------------------------------------
    // Here, we can assume
    // --  n is an integer >= 1
    // --  x can be converted to a float, i.e., 
    //     trunc(x) produces an integer
    // --  p can be symbolic or numeric
    // ---------------------------------------

    // Do the summation  
    //     _plus(binomial(n, k)*p^k*q^(n-k), k = 0.. trunc(x))
    // If x is close to n, use
    //   1 -  _plus(binomial(n, k)*p^k*q^(n-k), k = trunc(x) + 1 ..n)
    // = 1 -  _plus(binomial(n, k)*q^k*p^(n-k), k = 0 .. n - 1 - trunc(x)
    tx:= trunc(x);
    tnx:= nn - 1 - trunc(x);
    if tx <= tnx then  // trunc(x) is closer to 0 than to n.
                       // Sum from left to right:
         if iszero(qq) then
            if float(x - nn) < 0 then
               s := 0*tmp; // 0 or 0.0
            else
               s:= tmp; // 1 or 1.0
            end_if;
         else
            s := qq^nn;
            // tmp was initialized to 1 or 1.0 above
            tmp:= s; // qq^nn or 1.0*qq^nn
            for k from 1 to tx do
                tmp:= tmp*(nn-k+1)/k*pp/qq: // tmp = binomial(n,k)*p^k*q^(n-k)
                s := s + tmp:
            end_for;
         end_if;
         if domtype(x) = DOM_FLOAT then
              return(float(s));
         else return(s);
         end_if;
    else // trunc(x) is closer to n than to 0.
         // Sum from right to left
         if iszero(pp) then
            if float(x - nn) < 0 then
               s:= 0*tmp; // 0 or 0.0
            else
               s := tmp; // 1 or 1.0;
            end_if;
         else
            s:= pp^nn;
            // tmp was initialized to 1 or 1.0 above
            tmp:= s; // pp^n or 1.0*pp^nn
            for k from 1 to tnx do
                tmp:= tmp*(nn-k+1)/k*qq/pp: // tmp = binomial(n,k)*p^(n-k)*q^k
                s:= s + tmp:
            end_for;
         end_if;
         if domtype(x) = DOM_FLOAT then
              return(float(1 - s));
         else return(1 - s);
         end_if;
    end_if;

    //--------------------------------------------------
    // We should not arrive here. For safety, insert the
    // following code, anyway:
    //--------------------------------------------------
    // return nn = context(n), pp = context(p) rather than n, p
    return(hold(stats::binomialCDF)(nn, pp)(x));
  end_proc:
end_proc:
