/*

Call:          f:= stats::chisquareCDF(m)

Parameter(s):  m - the mean: an arithmetical expression
                   representing a positive real value

Returns: a procedure

------------------------------------*/
/*
Walter Oevel, 22.7.01
  - ueberarbeitet, sollte ok sein
  - Todo: - a bit more internal documentation (comments
            in the header) would be nice
          - Apart from this: OK
*/

stats::chisquareCDF:= proc(m)
local fm;
option escape;
begin
  if args(0) <> 1 then
     error("expecting one argument")
  end_if;

  // ------------- check m -------------
  fm:= float(m):
  if domtype(fm) = DOM_FLOAT and fm <= 0 then
     error("the mean must be positive"):
  end_if;
  if domtype(fm) = DOM_COMPLEX then
     error("the mean must be real");
  end_if;

  //-------------------------------
  // return the following procedure
  //-------------------------------
  proc(x)
  local mm, m2, fm2, x2, fx2, del, su, bla, macheps;
  begin
    if args(0) <> 1 then 
       error("expecting one argument")
    end_if:

    // ------------- check m -------------
    mm:= context(m):
    m2:= mm/2;
    fm2:= float(m2):
    if domtype(fm2) = DOM_FLOAT and fm2 <= 0 then
       error("the mean must be positive"):
    end_if;
    if domtype(fm2) = DOM_COMPLEX then
       error("the mean must be real");
    end_if;

    // ------------- check x -------------
    x2:= x/2;
    fx2:= float(x2);
    if domtype(fx2) = DOM_COMPLEX then
       error("expecting a real argument");
    end_if;

    // --------- float evaluation ? ------------
    if domtype(x) = DOM_FLOAT and
       domtype(fm2) = DOM_FLOAT then
       // beware of cancellation. If x/2 > m + 1,
       // 1 - igamma(m/2, x/2)/gamma(m/2) is numerically
       // stable:
       if x <= 0  then
            return(float(0));
       elif x2 < fm2 + 1 then
            // compute 1 - igamma(m/2, x/2)/gamma(m/2) by
            // a series expansion. This is numerically
            // stable because it avoids the cancellation
            //  1 - (something close to 1)
            macheps:= 10.0^(-DIGITS): 
            del:= 1/fm2:
            su:= del:
            bla:= fm2:
            while del > su*macheps do
              bla:= bla + 1:
              del:= del*x2/bla:
              su:= su + del:
            end_while:
            return(su*exp::float(-fx2)*(fx2)^fm2/gamma(fm2));
       else // x2 >= fm2 + 1
            return(1 - igamma(fm2, x2)/gamma(fm2));
       end_if: 
    end_if:

    // Now, the symbolic part starts.
    // Do not use floating point conversion, but
    // work with the original values m2 = mm/2, x2 = x/2:

    // First, avoid the costly 'is' call, if possible:
    case domtype(x)
    of DOM_INT do
    of DOM_RAT do
       if x > 0 then
          return(1 - igamma(m2, x2)/gamma(m2));
       end_if:
       if x <= 0  then 
          return(0);
       end_if:
       break;
    of DOM_FLOAT do
       if x > 0 then
          return(float(1 - igamma(fm2, fx2)/gamma(fm2)));
       end_if:
       if x <= 0  then 
          return(float(0));
       end_if:
    end_case;

    // ---- can side condition x >= 0 be decided? ----
    // ---- return an explicit result if possible ----

    // do test x >= 0 as well as x <= 0, not just x > 0, x <= 0 !
    if is(x >= 0) = TRUE  then
        return(1 - igamma(m2, x2)/gamma(m2));
    end_if:

    if is(x <= 0) = TRUE then
        return(0);       
    end_if;

    // Here, 0 < x could not be decided.
    return(hold(stats::chisquareCDF)(mm)(x));
  end_proc:
end_proc:
