
/*
Walter Oevel, 23.7.01
  - ueberarbeitet, sollte ok sein
  - Todo: - a bit more internal documentation (comments
            in the header) would be nice
          - Apart from this: OK
*/


stats::erlangCDF:= proc(a, b)
local fa, fb;
option escape;
begin
  if args(0) <> 2 then
     error("expecting two arguments")
  end_if;

  // ------------- check a -------------
  fa:= float(a):
  if domtype(fa) = DOM_FLOAT and fa <= 0 then
     error("the shape parameter must be positive"):
  end_if;
  if domtype(fa) = DOM_COMPLEX then
     error("the shape parameter must be real");
  end_if;


  // ------------- check b -------------
  fb:= float(b):
  if domtype(fb) = DOM_FLOAT and fb <= 0 then
     error("the scale parameter must be positive"):
  end_if;
  if domtype(fb) = DOM_COMPLEX then
     error("the scale parameter must be real");
  end_if;

  //-------------------------------
  // return the following procedure
  //-------------------------------
  proc(x)
  local aa, bb, fa, fb, fx, xfb, del, su, bla, macheps;
  begin
      if args(0) <> 1 
         then error("expecting one argument")
      end_if:

     // ------------- check a -------------
     aa:= context(a):
     fa:= float(aa):
     if domtype(fa) = DOM_FLOAT and fa <= 0 then
        error("the shape parameter must be positive"):
     end_if;
     if domtype(fa) = DOM_COMPLEX then
        error("the shape parameter must be real");
     end_if;

     // ------------- check b -------------
     bb:= context(b):
     fb:= float(bb):
     if domtype(fb) = DOM_FLOAT and fb <= 0 then
        error("the scale parameter must be positive"):
     end_if;
     if domtype(fb) = DOM_COMPLEX then
        error("the scale parameter must be real");
     end_if;

     // ------------- check x -------------
     fx:= float(x);
     if domtype(fx) = DOM_COMPLEX then
        error("expecting a real argument");
     end_if;

    // --------- float evaluation ? ----------
    if domtype(x) = DOM_FLOAT and
       domtype(fa) = DOM_FLOAT and
       domtype(fb) = DOM_FLOAT then
       // beware of cancellation. If x*b  >= a + 1,
       // 1 - igamma(a, x*b)/gamma(a) is numerically
       // stable:
       xfb:= x*fb;
       if x <= 0  then
            return(float(0));
       elif x*fb< fa+1 then
            // compute 1 - igamma(a, x*b)/gamma(a) by
            // a series expansion. This is numerically
            // stable because it avoids the cancellation
            //  1 - (something close to 1)
            macheps:=10.0^(-DIGITS): 
            del:= 1/fa:
            su:= del:
            bla:= fa:
            while del > su*macheps do
              bla:= bla+1:
              del:= del*xfb/bla:
              su:=su + del:
            end_while:
            return(su*exp::float(-xfb)*(xfb)^fa/gamma(fa));
       else // x*fb >= fa+1  then
            return(1 - igamma(fa, xfb)/gamma(fa));
       end_if: 
    end_if:

    // Now, the symbolic part starts.
    // Do not use floating point conversion, but
    // work with the original values aa, bb, x

    // First, avoid the costly 'is' call, if possible:

    case domtype(x)
    of DOM_INT do
    of DOM_RAT do
        if x > 0 then
             return(1 - igamma(aa, x*bb)/gamma(aa));
        end_if:
        if x <= 0  then 
           return(0);
        end_if:
    of DOM_FLOAT do
        if x > 0 then
             return(float(1 - igamma(fa, x*fb)/gamma(fa)));
        end_if:
        if x <= 0  then 
           return(float(0));
        end_if:
    end_case;

    // ---- can side condition x >= 0 be decided? ----
    // ---- return an explicit result if possible ----

    // do test x >= 0 as well as x <= 0, not just x > 0, x <= 0 !
    if is(x >= 0) = TRUE  then
             return(1 - igamma(aa, x*bb)/gamma(aa));
    end_if:

    if is(x <= 0) = TRUE then
        return(0);       
    end_if;

    // Here, 0 =< x  could not be decided.
    return(hold(stats::erlangCDF)(aa, bb)(x));
  end_proc:
end_proc:
