/*
Walter Oevel, 17.7.01
  - ueberarbeitet, sollte ok sein
  - Todo: - a bit more internal documentation (comments
            in the header) would be nice
          - Apart from this: OK
*/

stats::cauchyPDF := proc(a, b)
local fa, fb;
option escape;
begin
  if args(0)<>2 then
      error("expecting two arguments")
  end_if:

  // ------------- check a -------------
  fa:= float(a):
  if domtype(fa) = DOM_COMPLEX then
     error("the median must be real");
  end_if;
  
  // ------------- check b -------------
  fb:=float(b):
  if domtype(fb) = DOM_FLOAT and fb <= 0 then
     error("the scale parameter must be positive"):
  end_if;
  if domtype(fb) = DOM_COMPLEX then
     error("the scale parameter must be real");
  end_if;
  
  //-------------------------------
  // return the following procedure
  //-------------------------------
    
  proc(x)
  local aa, bb, fa, fb, t, u, fu, fx;                 
  begin 
    if args(0)<>1 then
       error("one argument expected")
    end_if:

    // ------------- check a -------------
    aa :=context(a):
    fa:= float(aa):
    if domtype(fa) = DOM_COMPLEX then
       error("the median must be real");
    end_if;
    
    // ------------- check b -------------
    bb:= context(b): 
    fb:= float(bb):
    if domtype(fb) = DOM_FLOAT and fb <= 0 then
       error("the scale parameter must be positive"):
    end_if;
    if domtype(fb) = DOM_COMPLEX then
       error("the scale parameter must be real");
    end_if;

    // ------------- check x -------------
    fx:= float(x);
    if domtype(fx) = DOM_COMPLEX then
       error("expecting a real argument");
    end_if;

    // --------------------------------------------
    // special cases:
    // --------------------------------------------
    if x = -infinity then return(0) end_if;
    if x = infinity then return(0) end_if;

    //------------------------------------
    t:= bb^2 + (x-aa)^2:
    u:= bb/t/PI:
    fu:= float(u):
    if domtype(fu) <> DOM_FLOAT and 
       domtype(fu) <> DOM_COMPLEX then
       // some of the parameters is symbolic
       return(u) 
    end_if:
    if domtype(x) = DOM_FLOAT then
         return(fu);
    else return(u);
    end_if:      
  end_proc:
end_proc:
