/*
Call:          stats::chisquarePDF(m)

Parameter(s):  m - the mean: an arithmetical expression
                   representing a positive real value

Returns: a procedure

------------------------------------*/

stats::chisquarePDF := proc(m)
local fm;
option escape;
begin
  if args(0) <> 1 then
     error("expecting one argument")
  end_if;

  // ------------- check m -------------
  fm:= float(m):
  if domtype(fm) = DOM_FLOAT and fm <= 0 then
     error("the mean must be positive"):
  end_if;
  if domtype(fm) = DOM_COMPLEX then
     error("the mean must be real");
  end_if;

  //-------------------------------
  // return the following procedure
  //-------------------------------
  proc(x)
  local mm, m2, fm2, x2, fx2, r;
  begin
    if args(0)<>1 then 
       error("expecting one argument")
    end_if:

    // ------------- check m -------------
    mm:= context(m):
    m2:= mm/2;
    fm2:= float(m2):
    if domtype(fm2) = DOM_FLOAT and fm2 <= 0 then
       error("the mean must be positive"):
    end_if;
    if domtype(fm2) = DOM_COMPLEX then
       error("the mean must be real");
    end_if;

    // ------------- check x -------------
    x2:= x/2;
    fx2:= float(x2);
    if domtype(fx2) = DOM_COMPLEX then
       error("expecting a real argument");
    end_if;

    // --------- float evaluation ? ------------

    if domtype(x) = DOM_FLOAT and
       domtype(fm2) = DOM_FLOAT  then
       if x <= 0  then
            return(float(0));
       else // x > 0  
            return(fx2^(fm2)/x/gamma(fm2)*exp::float(-fx2));
       end_if:
    end_if:

    // Now, the symbolic part starts.
    // Do not use floating point conversion, but
    // work with the original values m2 = mm/2, x2 = x/2:


    // Avoid the costly 'is' call, if possible:
    
    case domtype(x)
    of DOM_INT do
    of DOM_RAT do
        if x <= 0  then 
           return(0);
        end_if:
        if x > 0 then
           r:= x^(m2 - 1)/2^m2/gamma(m2):
           return(r*exp(-x2));
        end_if:
        break;
    of DOM_FLOAT do
        if x <= 0  then 
           return(float(0));
        end_if:
        if x > 0 then
           r:= x^(fm2 - 1)/2^fm2/gamma(fm2):
           return(r*exp(-fx2));
        end_if:
    end_case;

    // ---- can side condition x >= 0 be decided? ----
    // ---- return an explicit result if possible ----

    // do test x >= 0 as well as x <= 0, not just x > 0, x <= 0 !
    if is(x >= 0) = TRUE  then
             r:= x^(m2 - 1)/2^m2/gamma(m2):
             return(r*exp(-x2));
    end_if:

    if is(x <= 0) = TRUE then
        return(0);       
    end_if;

    // Here, 0 < x  could not be decided.
    // ---- return symbolic XPDF(parameters)(x) ----
    return(hold(stats::chisquarePDF)(mm)(x));
  end_proc:
end_proc:
