/*
Walter Oevel, 22.7.01
  - ueberarbeitet, sollte ok sein
  - Todo: - a bit more internal documentation (comments
            in the header) would be nice
          - Apart from this: OK
*/


stats::erlangPDF := proc(a, b)
local fa, fb;
option escape;
begin
  if args(0)<>2 then
     error("expecting two arguments")
  end_if;

  // ------------- check a -------------
  fa:= float(a):
  if domtype(fa) = DOM_FLOAT and fa <= 0 then
     error("the shape parameter must be positive"):
  end_if;
  if domtype(fa) = DOM_COMPLEX then
     error("the shape parameter must be real");
  end_if;


  // ------------- check b -------------
  fb:= float(b):
  if domtype(fb) = DOM_FLOAT and fb <= 0 then
     error("the scale parameter must be positive"):
  end_if;
  if domtype(fb) = DOM_COMPLEX then
     error("the scale parameter must be real");
  end_if;

  //-------------------------------
  // return the following procedure
  //-------------------------------
  proc(x)
  local aa, bb, fa, fb, fx, xfb, r;
  begin
    if args(0)<>1 
       then error("expecting one argument")
    end_if:

     // ------------- check a -------------
     aa:= context(a):
     fa:= float(aa):
     if domtype(fa) = DOM_FLOAT and fa <= 0 then
        error("the shape parameter must be positive"):
     end_if;
     if domtype(fa) = DOM_COMPLEX then
        error("the shape parameter must be real");
     end_if;

     // ------------- check b -------------
     bb:= context(b):
     fb:= float(bb):
     if domtype(fb) = DOM_FLOAT and fb <= 0 then
        error("the scale parameter must be positive"):
     end_if;
     if domtype(fb) = DOM_COMPLEX then
        error("the scale parameter must be real");
     end_if;

     // ------------- check x -------------
     if x = infinity then
        return(0)
     end_if;
     fx:= float(x);
     if domtype(fx) = DOM_COMPLEX then
        error("expecting a real argument");
     end_if;

    // --------- float evaluation ? ----------
    if domtype(x)=DOM_FLOAT and
       domtype(fa) = DOM_FLOAT  and
       domtype(fb) = DOM_FLOAT  then
       if x <= 0  then
            return(float(0));
       else xfb:= x*fb;
            return((xfb)^fa/x/gamma(fa)*exp::float(-xfb));
       end_if:
    end_if:

    // Now, the symbolic part stats.
    // Do no use floating point conversion, but
    // work with the original values a, b, x:

    // Avoid the costly is call, if possible:

    case domtype(x)
    of DOM_INT do
    of DOM_RAT do
        if x <= 0  then 
           return(0);
        end_if:
        if x > 0 then
             r:= x^(aa - 1)/gamma(aa)*bb^aa:
             return(r*exp(-x*bb));
        end_if:
    of DOM_FLOAT do
        if x <= 0  then 
           return(float(0));
        end_if:
        if x > 0 then
             r:= x^(fa - 1)/gamma(fa)*fb^fa:
             return(r*exp(-fx*fb));
        end_if:
    end_case;

    // ---- can side condition x >= 0 be decided? ----
    // ---- return an explicit result if possible ----

    // test x > 0 as well as x <= 0
    if is(x > 0) = TRUE  then
             r:= x^(aa - 1)/gamma(aa)*bb^aa:
             return(r*exp(-x*bb));
    end_if:

    if is(x <= 0)=TRUE then
        return(0);       
    end_if;

    // Here, 0 < x  could not be decided.
    // ---- return symbolic XPDF(parameters)(x) ----
    return(hold(stats::erlangPDF)(aa, bb)(x));
  end_proc:
end_proc:
