/* ----------------------------------------------------
Walter Oevel, 26.8.01
  - ueberarbeitet, sollte ok sein
  - Todo: - a bit more internal documentation (comments
            in the header) would be nice
          - Apart from this: OK
---------------------------------------------------- */

stats::logisticPDF := proc(m, s)
local fm, fs;
option escape;
begin
  if args(0) <> 2 then
      error("expecting two arguments")
  end_if:
  // ------------- check m -------------
  fm:= float(m):
  if domtype(fm) = DOM_COMPLEX then
     error("the mean must be real");
  end_if;

  // ------------- check s -------------
  fs:= float(s):
  if domtype(fs) = DOM_FLOAT and fs <= 0 then
     error("the standard deviation must be positive"):
  end_if;
  if domtype(fs) = DOM_COMPLEX then
     error("the standard deviation must be real");
  end_if;

  //-------------------------------
  // return the following procedure
  //-------------------------------
  proc(x)
  local  mm, fm, ss, fs, fx, u, fu, w, fw;
  begin 
    if args(0)<>1 then
      error("expecting one argument")
    end_if:

    // ------------- check m -------------
    mm:= context(m):
    fm:= float(mm):
    if domtype(fm) = DOM_COMPLEX then
       error("the mean must be real");
    end_if;
 
    // ------------- check s -------------
    ss:= context(s):
    fs:= float(ss):
    if domtype(fs) = DOM_FLOAT and fs <= 0 then
       error("the standard deviation must be positive"):
    end_if;
    if domtype(fs) = DOM_COMPLEX then
       error("the standard deviation must be real");
    end_if;

     // ------------- check x -------------
     fx:= float(x);
     if domtype(fx) = DOM_COMPLEX then
        error("expecting a real argument");
     end_if;

     u:= 3^(1/2)*ss/PI:
     fu:= float(u):
     w:= (x - mm)/u/2:
     fw:= float(w):

     // --------- float evaluation ? ----------
     if domtype(x) = DOM_FLOAT and
        domtype(fu) = DOM_FLOAT and
        domtype(fw) = DOM_FLOAT then

        return(1/cosh::float(fw)^2/4/fu);
     end_if;

     return(1/cosh(w)^2/4/u);
  end_proc:
end_proc:
