/*
Walter Oevel, 22.8.01
  - ueberarbeitet, sollte ok sein
  - Todo: - a bit more internal documentation (comments
            in the header) would be nice
          - Apart from this: OK
*/

stats::tPDF := proc(a)
local fa;
option escape; 
begin
  if args(0)<>1 then
      error("expecting one argument")
  end_if:

  // ------------- check a -------------
  fa:= float(a):
  if domtype(fa) = DOM_FLOAT and fa <= 0 then
     error("the shape parameter must be positive"):
  end_if;
  if domtype(fa) = DOM_COMPLEX then
     error("the shape parameter must be real");
  end_if;

  //-------------------------------
  // return the following procedure
  //-------------------------------
  proc(x)
  local aa, fa, fx, pi, t, s;
  begin
     if args(0) <> 1 then
        error("expecting one argument")
     end_if:

     // ------------- check a -------------
     aa:= context(a):
     fa:= float(aa):
     if domtype(fa) = DOM_FLOAT and fa <= 0 then
        error("the shape parameter must be positive"):
     end_if;
     if domtype(fa) = DOM_COMPLEX then
        error("the shape parameter must be real");
     end_if;

     // ------------- check x -------------
     fx:= float(x);
     if domtype(fx) = DOM_COMPLEX then
        error("expecting a real argument");
     end_if;

     //--------------------------
     // special cases:
     //--------------------------
     if x =  infinity then return(float(0)): end_if;
     if x = -infinity then return(float(0)): end_if;

     // If x is a float, trigger float evaluation.
     // Otherwise, return a symbolic result:

     if domtype(x) = DOM_FLOAT then
          aa := fa;
          pi := float(PI):
     else pi:= PI;
     end_if;

     t:= 1 + x^2/aa:
     s:=gamma((aa + 1)/2)/gamma(aa/2)/sqrt(pi)/sqrt(aa):
     return(s*t^(-(aa + 1)/2)):
  end_proc:
end_proc:
