/*
Walter Oevel, 25.7.01
  - ueberarbeitet, sollte ok sein
  - Todo: - a bit more internal documentation (comments
            in the header) would be nice
          - Apart from this: OK
*/

stats::uniformPDF := proc(a, b)
local fa, fbma;
option escape;
begin
  if args(0) <> 2 then
     error("expecting two arguments")
  end_if:

  // ------------- check a -------------
  fa:= float(a):
  if domtype(fa) = DOM_COMPLEX then
     error("the left border must be real");
  end_if;

  // ------------- check b -------------
  if domtype(float(b)) = DOM_COMPLEX then
     error("the right border must be real");
  end_if;

  fbma:= float(b - a):

  if domtype(fbma) = DOM_FLOAT and fbma < 0 then
     error("the left border must not exceed the right border"):
  end_if;

  //-------------------------------
  // return the following procedure
  //-------------------------------

  proc(x)
  local aa, bb, fa, fb, fx, bma, fbma, xma, fxma, bmx, fbmx;
  begin
     if args(0) <> 1 then
        error("one argument expected")
     end_if:

     // ------------- check a -------------
     aa:= context(a):
     fa:= float(aa):
     if domtype(fa) = DOM_COMPLEX then
        error("the left border must be real");
     end_if;
  
     // ------------- check b -------------
     bb:= context(b):
     fb:= float(bb):
     if domtype(fb) = DOM_COMPLEX then
        error("the right border must be real");
     end_if;
  
     bma:= bb - aa;
     fbma:= float(bma):
  
     if domtype(fbma) = DOM_FLOAT and fbma < 0 then
        error("the left border must not exceed the right border"):
     end_if;

     // ------------- check x -------------
     fx:= float(x):
     if domtype(fx) = DOM_COMPLEX then
        error("expecting a real argument");
     end_if;

     //----------------------------------------------
     // decide whether a <= x <= b holds.
     //----------------------------------------------

     // First, try to avoid costly 'is' calls by
     // straightforward float comparisons:

     xma := x - aa;
     fxma := float(xma):
     bmx := bb - x;
     fbmx := float(bmx):

     //----------------------------------------------
     // Special case b = a. 
     // We have 0 for x <> a = b and infinity for a = b = x:
     //----------------------------------------------
     if iszero(bma) then
       if iszero(xma) then
            return(infinity)
       else if domtype(x) = DOM_FLOAT then
                 return(float(0));
            else return(0);
            end_if;
       end_if;
     end_if;

     //----------------------------------------------
     // Special case b <> a, x = a or x = b.
     //----------------------------------------------
     if iszero(xma) or iszero(bmx) then
        if domtype(x) = DOM_FLOAT then
             return(1/fbma):
        else return(1/bma):
        end_if;
     end_if;

     //----------------------------------------------
     // General case b <> a. 
     //----------------------------------------------
     if domtype(fxma) = DOM_FLOAT and fxma < 0 then
        if domtype(x) = DOM_FLOAT then
             return(float(0));
        else return(0);
        end_if;
     end_if;

     if domtype(fbmx) = DOM_FLOAT and fbmx < 0 then
        if domtype(x) = DOM_FLOAT then
             return(float(0));
        else return(0);
        end_if;
     end_if;

     if domtype(fxma) = DOM_FLOAT and fxma >= 0 and
        domtype(fbmx) = DOM_FLOAT and fbmx >= 0 then
        if domtype(x) = DOM_FLOAT then
             return(1/fbma):
        else return(1/bma):
        end_if;
     end_if;

     //----------------------------------------------
     // Now, the symbolic part using properties starts.
     // - can side condition a <= x <= b be decided? --
     // - return an explicit result if possible ----
     
     //----------------------------------------------
     // The special case b = a was taken care of above
     //----------------------------------------------

     //----------------------------------------------
     // generic case b <> a:
     //----------------------------------------------
     if is(xma < 0) = TRUE then
        if domtype(x) = DOM_FLOAT then
             return(float(0));
        else return(0);
        end_if;
     end_if:

     if is(bmx < 0) = TRUE then
        if domtype(x) = DOM_FLOAT then
           return(float(0));
        else return(0);
        end_if;
     end_if:

     if is(0 <= xma) = TRUE and is(0 <= bmx) = TRUE  then
         if domtype(x) = DOM_FLOAT then
              return(1/fbma);
         else return(1/bma);
         end_if;
     end_if;

     //----------------------------------------
     // Here, a <= x <= b could not be decided.
     //----------------------------------------
     return(hold(stats::uniformPDF)(aa, bb)(x));
  end_proc:
end_proc:
